@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A multi-stage process to perform update operations across members of a Fleet.
 * @property eTag If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property managedClusterUpdate The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the run is started.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the UpdateRun resource.
 * @property status The status of the UpdateRun.
 * @property strategy The strategy defines the order in which the clusters will be updated.
 * If not set, all members will be updated sequentially. The UpdateRun status will show a single UpdateStage and a single UpdateGroup targeting all members.
 * The strategy of the UpdateRun can be modified until the run is started.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUpdateRunResult(
    public val eTag: String,
    public val id: String,
    public val managedClusterUpdate: ManagedClusterUpdateResponse,
    public val name: String,
    public val provisioningState: String,
    public val status: UpdateRunStatusResponse,
    public val strategy: UpdateRunStrategyResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.GetUpdateRunResult):
            GetUpdateRunResult = GetUpdateRunResult(
            eTag = javaType.eTag(),
            id = javaType.id(),
            managedClusterUpdate = javaType.managedClusterUpdate().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterUpdateResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStatusResponse.Companion.toKotlin(args0)
            }),
            strategy = javaType.strategy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateRunStrategyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerservice.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
