@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * See [AKS custom node configuration](https://docs.microsoft.com/azure/aks/custom-node-configuration) for more details.
 * @property swapFileSizeMB The size in MB of a swap file that will be created on each node.
 * @property sysctls Sysctl settings for Linux agent nodes.
 * @property transparentHugePageDefrag Valid values are 'always', 'defer', 'defer+madvise', 'madvise' and 'never'. The default is 'madvise'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
 * @property transparentHugePageEnabled Valid values are 'always', 'madvise', and 'never'. The default is 'always'. For more information see [Transparent Hugepages](https://www.kernel.org/doc/html/latest/admin-guide/mm/transhuge.html#admin-guide-transhuge).
 */
public data class LinuxOSConfigResponse(
    public val swapFileSizeMB: Int? = null,
    public val sysctls: SysctlConfigResponse? = null,
    public val transparentHugePageDefrag: String? = null,
    public val transparentHugePageEnabled: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.LinuxOSConfigResponse):
            LinuxOSConfigResponse = LinuxOSConfigResponse(
            swapFileSizeMB = javaType.swapFileSizeMB().map({ args0 -> args0 }).orElse(null),
            sysctls = javaType.sysctls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.SysctlConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            transparentHugePageDefrag = javaType.transparentHugePageDefrag().map({ args0 ->
                args0
            }).orElse(null),
            transparentHugePageEnabled = javaType.transparentHugePageEnabled().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
