@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * For more details see [managed AAD on AKS](https://docs.microsoft.com/azure/aks/managed-aad).
 * @property adminGroupObjectIDs The list of AAD group object IDs that will have admin role of the cluster.
 * @property clientAppID (DEPRECATED) The client AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
 * @property enableAzureRBAC Whether to enable Azure RBAC for Kubernetes authorization.
 * @property managed Whether to enable managed AAD.
 * @property serverAppID (DEPRECATED) The server AAD application ID. Learn more at https://aka.ms/aks/aad-legacy.
 * @property serverAppSecret (DEPRECATED) The server AAD application secret. Learn more at https://aka.ms/aks/aad-legacy.
 * @property tenantID The AAD tenant ID to use for authentication. If not specified, will use the tenant of the deployment subscription.
 */
public data class ManagedClusterAADProfileResponse(
    public val adminGroupObjectIDs: List<String>? = null,
    public val clientAppID: String? = null,
    public val enableAzureRBAC: Boolean? = null,
    public val managed: Boolean? = null,
    public val serverAppID: String? = null,
    public val serverAppSecret: String? = null,
    public val tenantID: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterAADProfileResponse):
            ManagedClusterAADProfileResponse = ManagedClusterAADProfileResponse(
            adminGroupObjectIDs = javaType.adminGroupObjectIDs().map({ args0 -> args0 }),
            clientAppID = javaType.clientAppID().map({ args0 -> args0 }).orElse(null),
            enableAzureRBAC = javaType.enableAzureRBAC().map({ args0 -> args0 }).orElse(null),
            managed = javaType.managed().map({ args0 -> args0 }).orElse(null),
            serverAppID = javaType.serverAppID().map({ args0 -> args0 }).orElse(null),
            serverAppSecret = javaType.serverAppSecret().map({ args0 -> args0 }).orElse(null),
            tenantID = javaType.tenantID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
