@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Profile of the managed cluster NAT gateway.
 * @property effectiveOutboundIPs The effective outbound IP resources of the cluster NAT gateway.
 * @property idleTimeoutInMinutes Desired outbound flow idle timeout in minutes. Allowed values are in the range of 4 to 120 (inclusive). The default value is 4 minutes.
 * @property managedOutboundIPProfile Profile of the managed outbound IP resources of the cluster NAT gateway.
 */
public data class ManagedClusterNATGatewayProfileResponse(
    public val effectiveOutboundIPs: List<ResourceReferenceResponse>? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val managedOutboundIPProfile: ManagedClusterManagedOutboundIPProfileResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterNATGatewayProfileResponse):
            ManagedClusterNATGatewayProfileResponse = ManagedClusterNATGatewayProfileResponse(
            effectiveOutboundIPs = javaType.effectiveOutboundIPs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            managedOutboundIPProfile = javaType.managedOutboundIPProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.ManagedClusterManagedOutboundIPProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
