@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * AzureDisk CSI Driver settings for the storage profile.
 * @property enabled Whether to enable AzureDisk CSI Driver. The default value is true.
 */
public data class ManagedClusterStorageProfileDiskCSIDriverResponse(
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.ManagedClusterStorageProfileDiskCSIDriverResponse):
            ManagedClusterStorageProfileDiskCSIDriverResponse =
            ManagedClusterStorageProfileDiskCSIDriverResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
