@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the update sequence of the clusters via stages and groups.
 * Stages within a run are executed sequentially one after another.
 * Groups within a stage are executed in parallel.
 * Member clusters within a group are updated sequentially one after another.
 * A valid strategy contains no duplicate groups within or across stages.
 * @property stages The list of stages that compose this update run. Min size: 1.
 */
public data class UpdateRunStrategyResponse(
    public val stages: List<UpdateStageResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerservice.outputs.UpdateRunStrategyResponse):
            UpdateRunStrategyResponse = UpdateRunStrategyResponse(
            stages = javaType.stages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerservice.kotlin.outputs.UpdateStageResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
