@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse
import com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerstorage.kotlin.outputs.ResourceOperationalStatusResponse.Companion.toKotlin as resourceOperationalStatusResponseToKotlin
import com.pulumi.azurenative.containerstorage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource =
            com.pulumi.azurenative.containerstorage.Snapshot(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-07-01-preview.
 * ## Example Usage
 * ### Snapshots_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.ContainerStorage.Snapshot("snapshot", new()
 *     {
 *         PoolName = "test-pool",
 *         ResourceGroupName = "test-rg",
 *         SnapshotName = "test-snapshot",
 *         Source = "C0C6I6",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerstorage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerstorage.NewSnapshot(ctx, "snapshot", &containerstorage.SnapshotArgs{
 * 			PoolName:          pulumi.String("test-pool"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SnapshotName:      pulumi.String("test-snapshot"),
 * 			Source:            pulumi.String("C0C6I6"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerstorage.Snapshot;
 * import com.pulumi.azurenative.containerstorage.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .poolName("test-pool")
 *             .resourceGroupName("test-rg")
 *             .snapshotName("test-snapshot")
 *             .source("C0C6I6")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerstorage:Snapshot test-snapshot /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerStorage/pools/{poolName}/snapshots/{snapshotName}
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.azurenative.containerstorage.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Reference to the source volume
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * The status of the resource.
     */
    public val status: Output<ResourceOperationalStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                resourceOperationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerstorage.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.azurenative.containerstorage.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit):
    Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
