@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin

import com.pulumi.azurenative.containerstorage.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-07-01-preview.
 * ## Example Usage
 * ### Snapshots_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.ContainerStorage.Snapshot("snapshot", new()
 *     {
 *         PoolName = "test-pool",
 *         ResourceGroupName = "test-rg",
 *         SnapshotName = "test-snapshot",
 *         Source = "C0C6I6",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerstorage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerstorage.NewSnapshot(ctx, "snapshot", &containerstorage.SnapshotArgs{
 * 			PoolName:          pulumi.String("test-pool"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SnapshotName:      pulumi.String("test-snapshot"),
 * 			Source:            pulumi.String("C0C6I6"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerstorage.Snapshot;
 * import com.pulumi.azurenative.containerstorage.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .poolName("test-pool")
 *             .resourceGroupName("test-rg")
 *             .snapshotName("test-snapshot")
 *             .source("C0C6I6")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerstorage:Snapshot test-snapshot /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerStorage/pools/{poolName}/snapshots/{snapshotName}
 * ```
 * @property poolName Pool Object
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotName Volume Snapshot Resource
 * @property source Reference to the source volume
 */
public data class SnapshotArgs(
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val snapshotName: Output<String>? = null,
    public val source: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.SnapshotArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.SnapshotArgs =
        com.pulumi.azurenative.containerstorage.SnapshotArgs.builder()
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var snapshotName: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value Pool Object
     */
    @JvmName("vfmlyconodubltyc")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fbnaoeobiohejgml")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Volume Snapshot Resource
     */
    @JvmName("edgdqlsykiesaecv")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value Reference to the source volume
     */
    @JvmName("ssymcprrwmoowdoi")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Pool Object
     */
    @JvmName("duaecblpicinqxyl")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nxpajtdljsrdveui")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Volume Snapshot Resource
     */
    @JvmName("expdvmaskoabxiop")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    /**
     * @param value Reference to the source volume
     */
    @JvmName("nlqakfyahdkddinp")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        snapshotName = snapshotName,
        source = source,
    )
}
