@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
 */
public enum class ManagedServiceIdentityType(
    public val javaValue: com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType> {
    None(com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.enums.ManagedServiceIdentityType):
            ManagedServiceIdentityType =
            ManagedServiceIdentityType.values().first { it.javaValue == javaType }
    }
}
