@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.inputs

import com.pulumi.azurenative.containerstorage.inputs.GetPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property poolName Pool Object
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPoolPlainArgs(
    public val poolName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerstorage.inputs.GetPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerstorage.inputs.GetPoolPlainArgs =
        com.pulumi.azurenative.containerstorage.inputs.GetPoolPlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoolPlainArgs].
 */
@PulumiTagMarker
public class GetPoolPlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Pool Object
     */
    @JvmName("tmjhaxpgchpnpfmh")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqmjukhejfpstavl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPoolPlainArgs = GetPoolPlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
