@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the ElasticSAN iSCSI target
 * @property targetIqn iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server"
 * @property targetPortalHostname iSCSI Target Portal Host Name
 * @property targetPortalPort iSCSI Target Portal Port
 */
public data class ElasticSanVolumePropertiesResponse(
    public val targetIqn: String,
    public val targetPortalHostname: String,
    public val targetPortalPort: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.ElasticSanVolumePropertiesResponse):
            ElasticSanVolumePropertiesResponse = ElasticSanVolumePropertiesResponse(
            targetIqn = javaType.targetIqn(),
            targetPortalHostname = javaType.targetPortalHostname(),
            targetPortalPort = javaType.targetPortalPort(),
        )
    }
}
