@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerstorage.kotlin.outputs

import kotlin.Suppress

/**
 * Type of the Pool: ephemeralDisk, azureDisk, or elasticsan
 * @property azureDisk Disk Pool Properties
 * @property elasticSan Elastic San Pool Properties
 * @property ephemeralDisk Ephemeral Pool Properties
 */
public data class PoolTypeResponse(
    public val azureDisk: AzureDiskResponse? = null,
    public val elasticSan: ElasticSanResponse? = null,
    public val ephemeralDisk: EphemeralDiskResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerstorage.outputs.PoolTypeResponse):
            PoolTypeResponse = PoolTypeResponse(
            azureDisk = javaType.azureDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.AzureDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            elasticSan = javaType.elasticSan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.ElasticSanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ephemeralDisk = javaType.ephemeralDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerstorage.kotlin.outputs.EphemeralDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
