@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionInfoResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionInfoResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CloudConnector].
 */
@PulumiTagMarker
public class CloudConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudConnectorArgs = CloudConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudConnectorArgsBuilder.() -> Unit) {
        val builder = CloudConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CloudConnector {
        val builtJavaResource =
            com.pulumi.azurenative.costmanagement.CloudConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudConnector(builtJavaResource)
    }
}

/**
 * The Connector model definition
 * Azure REST API version: 2019-03-01-preview. Prior API version in Azure Native 1.x: 2019-03-01-preview.
 * ## Example Usage
 * ### CloudConnector_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudConnector = new AzureNative.CostManagement.CloudConnector("cloudConnector", new()
 *     {
 *         ConnectorName = "aws-123456789012",
 *         CredentialsKey = "arn:aws:iam::123456789012:role/AzureCostManagementRole",
 *         CredentialsSecret = "external-id",
 *         DisplayName = "AWS-Consolidated-1",
 *         ReportId = "HourlyWithResources",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewCloudConnector(ctx, "cloudConnector", &costmanagement.CloudConnectorArgs{
 * 			ConnectorName:     pulumi.String("aws-123456789012"),
 * 			CredentialsKey:    pulumi.String("arn:aws:iam::123456789012:role/AzureCostManagementRole"),
 * 			CredentialsSecret: pulumi.String("external-id"),
 * 			DisplayName:       pulumi.String("AWS-Consolidated-1"),
 * 			ReportId:          pulumi.String("HourlyWithResources"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.CloudConnector;
 * import com.pulumi.azurenative.costmanagement.CloudConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudConnector = new CloudConnector("cloudConnector", CloudConnectorArgs.builder()
 *             .connectorName("aws-123456789012")
 *             .credentialsKey("arn:aws:iam::123456789012:role/AzureCostManagementRole")
 *             .credentialsSecret("external-id")
 *             .displayName("AWS-Consolidated-1")
 *             .reportId("HourlyWithResources")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:CloudConnector aws-123456789012 /providers/Microsoft.CostManagement/cloudConnectors/{connectorName}
 * ```
 */
public class CloudConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.CloudConnector,
) : KotlinCustomResource(javaResource, CloudConnectorMapper) {
    /**
     * Connector billing model
     */
    public val billingModel: Output<String>?
        get() = javaResource.billingModel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collection information
     */
    public val collectionInfo: Output<ConnectorCollectionInfoResponse>
        get() = javaResource.collectionInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Connector definition creation datetime
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Credentials authentication key (eg AWS ARN)
     */
    public val credentialsKey: Output<String>?
        get() = javaResource.credentialsKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of days remaining of trial
     */
    public val daysTrialRemaining: Output<Int>
        get() = javaResource.daysTrialRemaining().applyValue({ args0 -> args0 })

    /**
     * Default ManagementGroupId
     */
    public val defaultManagementGroupId: Output<String>?
        get() = javaResource.defaultManagementGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connector DisplayName
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Associated ExternalBillingAccountId
     */
    public val externalBillingAccountId: Output<String>
        get() = javaResource.externalBillingAccountId().applyValue({ args0 -> args0 })

    /**
     * Connector kind (eg aws)
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Connector last modified datetime
     */
    public val modifiedOn: Output<String>
        get() = javaResource.modifiedOn().applyValue({ args0 -> args0 })

    /**
     * Connector name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The display name of the providerBillingAccountId as defined on the external provider
     */
    public val providerBillingAccountDisplayName: Output<String>
        get() = javaResource.providerBillingAccountDisplayName().applyValue({ args0 -> args0 })

    /**
     * Connector providerBillingAccountId, determined from credentials (eg AWS Consolidated account number)
     */
    public val providerBillingAccountId: Output<String>
        get() = javaResource.providerBillingAccountId().applyValue({ args0 -> args0 })

    /**
     * Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
     */
    public val reportId: Output<String>?
        get() = javaResource.reportId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Connector status
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Billing SubscriptionId
     */
    public val subscriptionId: Output<String>?
        get() = javaResource.subscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connector type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CloudConnectorMapper : ResourceMapper<CloudConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.CloudConnector::class == javaResource::class

    override fun map(javaResource: Resource): CloudConnector = CloudConnector(
        javaResource as
            com.pulumi.azurenative.costmanagement.CloudConnector,
    )
}

/**
 * @see [CloudConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudConnector].
 */
public suspend fun cloudConnector(
    name: String,
    block: suspend CloudConnectorResourceBuilder.() -> Unit,
): CloudConnector {
    val builder = CloudConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudConnector(name: String): CloudConnector {
    val builder = CloudConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
