@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionInfoResponse
import com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionInfoResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource = com.pulumi.azurenative.costmanagement.Connector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connector(builtJavaResource)
    }
}

/**
 * The Connector model definition
 * Azure REST API version: 2018-08-01-preview.
 * ## Example Usage
 * ### Connector_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.CostManagement.Connector("connector", new()
 *     {
 *         ConnectorName = "AWSBillingAccount",
 *         CredentialsKey = "arn:aws:iam::123456789012:role/AzureCostManagementRole",
 *         CredentialsSecret = "external-id",
 *         DisplayName = "AWS-Consolidated-1",
 *         Location = "westus",
 *         ReportId = "HourlyWithResources",
 *         ResourceGroupName = "rg1",
 *         Status = AzureNative.CostManagement.ConnectorStatus.Active,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewConnector(ctx, "connector", &costmanagement.ConnectorArgs{
 * 			ConnectorName:     pulumi.String("AWSBillingAccount"),
 * 			CredentialsKey:    pulumi.String("arn:aws:iam::123456789012:role/AzureCostManagementRole"),
 * 			CredentialsSecret: pulumi.String("external-id"),
 * 			DisplayName:       pulumi.String("AWS-Consolidated-1"),
 * 			Location:          pulumi.String("westus"),
 * 			ReportId:          pulumi.String("HourlyWithResources"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Status:            pulumi.String(costmanagement.ConnectorStatusActive),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.Connector;
 * import com.pulumi.azurenative.costmanagement.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .connectorName("AWSBillingAccount")
 *             .credentialsKey("arn:aws:iam::123456789012:role/AzureCostManagementRole")
 *             .credentialsSecret("external-id")
 *             .displayName("AWS-Consolidated-1")
 *             .location("westus")
 *             .reportId("HourlyWithResources")
 *             .resourceGroupName("rg1")
 *             .status("active")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:Connector AWSBillingAccount /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.CostManagement/connectors/{connectorName}
 * ```
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.azurenative.costmanagement.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * Collection information
     */
    public val collection: Output<ConnectorCollectionInfoResponse>
        get() = javaResource.collection().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Connector definition creation datetime
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * Credentials authentication key (eg AWS ARN)
     */
    public val credentialsKey: Output<String>?
        get() = javaResource.credentialsKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connector DisplayName (defaults to Name)
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Connector kind (eg aws)
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Connector location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Connector last modified datetime
     */
    public val modifiedOn: Output<String>
        get() = javaResource.modifiedOn().applyValue({ args0 -> args0 })

    /**
     * Connector name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Connector providerAccountId (determined from credentials)
     */
    public val providerAccountId: Output<String>
        get() = javaResource.providerAccountId().applyValue({ args0 -> args0 })

    /**
     * Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
     */
    public val reportId: Output<String>?
        get() = javaResource.reportId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Connector status
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Connector type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.costmanagement.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.azurenative.costmanagement.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit):
    Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
