@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.CostAllocationRulePropertiesArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.CostAllocationRulePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The cost allocation rule model definition
 * Azure REST API version: 2020-03-01-preview. Prior API version in Azure Native 1.x: 2020-03-01-preview.
 * Other available API versions: 2023-08-01, 2023-09-01, 2023-11-01.
 * ## Example Usage
 * ### CostAllocationRulesCreateResourceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var costAllocationRule = new AzureNative.CostManagement.CostAllocationRule("costAllocationRule", new()
 *     {
 *         BillingAccountId = "100",
 *         Properties = new AzureNative.CostManagement.Inputs.CostAllocationRulePropertiesArgs
 *         {
 *             Description = "This is a testRule",
 *             Details = new AzureNative.CostManagement.Inputs.CostAllocationRuleDetailsArgs
 *             {
 *                 SourceResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.SourceCostAllocationResourceArgs
 *                     {
 *                         Name = "ResourceGroupName",
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Dimension,
 *                         Values = new[]
 *                         {
 *                             "sampleRG",
 *                             "secondRG",
 *                         },
 *                     },
 *                 },
 *                 TargetResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.TargetCostAllocationResourceArgs
 *                     {
 *                         Name = "ResourceGroupName",
 *                         PolicyType = AzureNative.CostManagement.CostAllocationPolicyType.FixedProportion,
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Dimension,
 *                         Values = new[]
 *                         {
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG",
 *                                 Percentage = 45,
 *                             },
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG2",
 *                                 Percentage = 54,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             Status = AzureNative.CostManagement.RuleStatus.Active,
 *         },
 *         RuleName = "testRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewCostAllocationRule(ctx, "costAllocationRule", &costmanagement.CostAllocationRuleArgs{
 * 			BillingAccountId: pulumi.String("100"),
 * 			Properties: &costmanagement.CostAllocationRulePropertiesArgs{
 * 				Description: pulumi.String("This is a testRule"),
 * 				Details: &costmanagement.CostAllocationRuleDetailsArgs{
 * 					SourceResources: costmanagement.SourceCostAllocationResourceArray{
 * 						&costmanagement.SourceCostAllocationResourceArgs{
 * 							Name:         pulumi.String("ResourceGroupName"),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeDimension),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("sampleRG"),
 * 								pulumi.String("secondRG"),
 * 							},
 * 						},
 * 					},
 * 					TargetResources: costmanagement.TargetCostAllocationResourceArray{
 * 						&costmanagement.TargetCostAllocationResourceArgs{
 * 							Name:         pulumi.String("ResourceGroupName"),
 * 							PolicyType:   pulumi.String(costmanagement.CostAllocationPolicyTypeFixedProportion),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeDimension),
 * 							Values: costmanagement.CostAllocationProportionArray{
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG"),
 * 									Percentage: pulumi.Float64(45),
 * 								},
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG2"),
 * 									Percentage: pulumi.Float64(54),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				Status: pulumi.String(costmanagement.RuleStatusActive),
 * 			},
 * 			RuleName: pulumi.String("testRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRule;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var costAllocationRule = new CostAllocationRule("costAllocationRule", CostAllocationRuleArgs.builder()
 *             .billingAccountId("100")
 *             .properties(CostAllocationRulePropertiesArgs.builder()
 *                 .description("This is a testRule")
 *                 .details(CostAllocationRuleDetailsArgs.builder()
 *                     .sourceResources(SourceCostAllocationResourceArgs.builder()
 *                         .name("ResourceGroupName")
 *                         .resourceType("Dimension")
 *                         .values(
 *                             "sampleRG",
 *                             "secondRG")
 *                         .build())
 *                     .targetResources(TargetCostAllocationResourceArgs.builder()
 *                         .name("ResourceGroupName")
 *                         .policyType("FixedProportion")
 *                         .resourceType("Dimension")
 *                         .values(
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG")
 *                                 .percentage(45)
 *                                 .build(),
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG2")
 *                                 .percentage(54)
 *                                 .build())
 *                         .build())
 *                     .build())
 *                 .status("Active")
 *                 .build())
 *             .ruleName("testRule")
 *             .build());
 *     }
 * }
 * ```
 * ### CostAllocationRulesCreateTag
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var costAllocationRule = new AzureNative.CostManagement.CostAllocationRule("costAllocationRule", new()
 *     {
 *         BillingAccountId = "100",
 *         Properties = new AzureNative.CostManagement.Inputs.CostAllocationRulePropertiesArgs
 *         {
 *             Description = "This is a testRule",
 *             Details = new AzureNative.CostManagement.Inputs.CostAllocationRuleDetailsArgs
 *             {
 *                 SourceResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.SourceCostAllocationResourceArgs
 *                     {
 *                         Name = "category",
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Tag,
 *                         Values = new[]
 *                         {
 *                             "devops",
 *                         },
 *                     },
 *                 },
 *                 TargetResources = new[]
 *                 {
 *                     new AzureNative.CostManagement.Inputs.TargetCostAllocationResourceArgs
 *                     {
 *                         Name = "ResourceGroupName",
 *                         PolicyType = AzureNative.CostManagement.CostAllocationPolicyType.FixedProportion,
 *                         ResourceType = AzureNative.CostManagement.CostAllocationResourceType.Dimension,
 *                         Values = new[]
 *                         {
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG",
 *                                 Percentage = 33.33,
 *                             },
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG2",
 *                                 Percentage = 33.33,
 *                             },
 *                             new AzureNative.CostManagement.Inputs.CostAllocationProportionArgs
 *                             {
 *                                 Name = "destinationRG3",
 *                                 Percentage = 33.34,
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *             Status = AzureNative.CostManagement.RuleStatus.Active,
 *         },
 *         RuleName = "testRule",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/costmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := costmanagement.NewCostAllocationRule(ctx, "costAllocationRule", &costmanagement.CostAllocationRuleArgs{
 * 			BillingAccountId: pulumi.String("100"),
 * 			Properties: &costmanagement.CostAllocationRulePropertiesArgs{
 * 				Description: pulumi.String("This is a testRule"),
 * 				Details: &costmanagement.CostAllocationRuleDetailsArgs{
 * 					SourceResources: costmanagement.SourceCostAllocationResourceArray{
 * 						&costmanagement.SourceCostAllocationResourceArgs{
 * 							Name:         pulumi.String("category"),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeTag),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("devops"),
 * 							},
 * 						},
 * 					},
 * 					TargetResources: costmanagement.TargetCostAllocationResourceArray{
 * 						&costmanagement.TargetCostAllocationResourceArgs{
 * 							Name:         pulumi.String("ResourceGroupName"),
 * 							PolicyType:   pulumi.String(costmanagement.CostAllocationPolicyTypeFixedProportion),
 * 							ResourceType: pulumi.String(costmanagement.CostAllocationResourceTypeDimension),
 * 							Values: costmanagement.CostAllocationProportionArray{
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG"),
 * 									Percentage: pulumi.Float64(33.33),
 * 								},
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG2"),
 * 									Percentage: pulumi.Float64(33.33),
 * 								},
 * 								&costmanagement.CostAllocationProportionArgs{
 * 									Name:       pulumi.String("destinationRG3"),
 * 									Percentage: pulumi.Float64(33.34),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 				Status: pulumi.String(costmanagement.RuleStatusActive),
 * 			},
 * 			RuleName: pulumi.String("testRule"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRule;
 * import com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRulePropertiesArgs;
 * import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var costAllocationRule = new CostAllocationRule("costAllocationRule", CostAllocationRuleArgs.builder()
 *             .billingAccountId("100")
 *             .properties(CostAllocationRulePropertiesArgs.builder()
 *                 .description("This is a testRule")
 *                 .details(CostAllocationRuleDetailsArgs.builder()
 *                     .sourceResources(SourceCostAllocationResourceArgs.builder()
 *                         .name("category")
 *                         .resourceType("Tag")
 *                         .values("devops")
 *                         .build())
 *                     .targetResources(TargetCostAllocationResourceArgs.builder()
 *                         .name("ResourceGroupName")
 *                         .policyType("FixedProportion")
 *                         .resourceType("Dimension")
 *                         .values(
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG")
 *                                 .percentage(33.33)
 *                                 .build(),
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG2")
 *                                 .percentage(33.33)
 *                                 .build(),
 *                             CostAllocationProportionArgs.builder()
 *                                 .name("destinationRG3")
 *                                 .percentage(33.34)
 *                                 .build())
 *                         .build())
 *                     .build())
 *                 .status("Active")
 *                 .build())
 *             .ruleName("testRule")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:costmanagement:CostAllocationRule testRule /providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.CostManagement/costAllocationRules/{ruleName}
 * ```
 * @property billingAccountId BillingAccount ID
 * @property properties Cost allocation rule properties
 * @property ruleName Cost allocation rule name. The name cannot include spaces or any non alphanumeric characters other than '_' and '-'. The max length is 260 characters.
 */
public data class CostAllocationRuleArgs(
    public val billingAccountId: Output<String>? = null,
    public val properties: Output<CostAllocationRulePropertiesArgs>? = null,
    public val ruleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs =
        com.pulumi.azurenative.costmanagement.CostAllocationRuleArgs.builder()
            .billingAccountId(billingAccountId?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CostAllocationRuleArgs].
 */
@PulumiTagMarker
public class CostAllocationRuleArgsBuilder internal constructor() {
    private var billingAccountId: Output<String>? = null

    private var properties: Output<CostAllocationRulePropertiesArgs>? = null

    private var ruleName: Output<String>? = null

    /**
     * @param value BillingAccount ID
     */
    @JvmName("ivyeuebboaajnatw")
    public suspend fun billingAccountId(`value`: Output<String>) {
        this.billingAccountId = value
    }

    /**
     * @param value Cost allocation rule properties
     */
    @JvmName("sxpmoktawnsxexcj")
    public suspend fun properties(`value`: Output<CostAllocationRulePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Cost allocation rule name. The name cannot include spaces or any non alphanumeric characters other than '_' and '-'. The max length is 260 characters.
     */
    @JvmName("gyfuluuabwhpasqy")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value BillingAccount ID
     */
    @JvmName("lldrnootbfjoscww")
    public suspend fun billingAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAccountId = mapped
    }

    /**
     * @param value Cost allocation rule properties
     */
    @JvmName("ebnyyditjxlrkhuh")
    public suspend fun properties(`value`: CostAllocationRulePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Cost allocation rule properties
     */
    @JvmName("cypsecghqhmgsjgx")
    public suspend
    fun properties(argument: suspend CostAllocationRulePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CostAllocationRulePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Cost allocation rule name. The name cannot include spaces or any non alphanumeric characters other than '_' and '-'. The max length is 260 characters.
     */
    @JvmName("smpndtlcheevtvlm")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    internal fun build(): CostAllocationRuleArgs = CostAllocationRuleArgs(
        billingAccountId = billingAccountId,
        properties = properties,
        ruleName = ruleName,
    )
}
