@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin

import com.pulumi.azurenative.costmanagement.ReportByResourceGroupNameArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.FormatType
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDefinitionArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDefinitionArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDeliveryInfoArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportDeliveryInfoArgsBuilder
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportScheduleArgs
import com.pulumi.azurenative.costmanagement.kotlin.inputs.ReportScheduleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A report resource.
 * Azure REST API version: 2018-08-01-preview. Prior API version in Azure Native 1.x: 2018-08-01-preview.
 * @property definition Has definition for the report.
 * @property deliveryInfo Has delivery information for the report.
 * @property format The format of the report being delivered.
 * @property reportName Report Name.
 * @property resourceGroupName Azure Resource Group Name.
 * @property schedule Has schedule information for the report.
 */
public data class ReportByResourceGroupNameArgs(
    public val definition: Output<ReportDefinitionArgs>? = null,
    public val deliveryInfo: Output<ReportDeliveryInfoArgs>? = null,
    public val format: Output<Either<String, FormatType>>? = null,
    public val reportName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schedule: Output<ReportScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.ReportByResourceGroupNameArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.ReportByResourceGroupNameArgs =
        com.pulumi.azurenative.costmanagement.ReportByResourceGroupNameArgs.builder()
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deliveryInfo(deliveryInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(
                format?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .reportName(reportName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReportByResourceGroupNameArgs].
 */
@PulumiTagMarker
public class ReportByResourceGroupNameArgsBuilder internal constructor() {
    private var definition: Output<ReportDefinitionArgs>? = null

    private var deliveryInfo: Output<ReportDeliveryInfoArgs>? = null

    private var format: Output<Either<String, FormatType>>? = null

    private var reportName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schedule: Output<ReportScheduleArgs>? = null

    /**
     * @param value Has definition for the report.
     */
    @JvmName("uwxqxpipndvyvwsl")
    public suspend fun definition(`value`: Output<ReportDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Has delivery information for the report.
     */
    @JvmName("bphlypjrotnponjg")
    public suspend fun deliveryInfo(`value`: Output<ReportDeliveryInfoArgs>) {
        this.deliveryInfo = value
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("drsewwjjcaquubuc")
    public suspend fun format(`value`: Output<Either<String, FormatType>>) {
        this.format = value
    }

    /**
     * @param value Report Name.
     */
    @JvmName("edlhbjyxlimxfrdb")
    public suspend fun reportName(`value`: Output<String>) {
        this.reportName = value
    }

    /**
     * @param value Azure Resource Group Name.
     */
    @JvmName("mceksxrljpcvkyhx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Has schedule information for the report.
     */
    @JvmName("fvtxejrdsbxageia")
    public suspend fun schedule(`value`: Output<ReportScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Has definition for the report.
     */
    @JvmName("mecgyvwuqpbaejvy")
    public suspend fun definition(`value`: ReportDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument Has definition for the report.
     */
    @JvmName("avxlwkpfbpvmwplv")
    public suspend fun definition(argument: suspend ReportDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Has delivery information for the report.
     */
    @JvmName("mmthomcoksbyaiwp")
    public suspend fun deliveryInfo(`value`: ReportDeliveryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryInfo = mapped
    }

    /**
     * @param argument Has delivery information for the report.
     */
    @JvmName("nplbfipgnurmdkrx")
    public suspend fun deliveryInfo(argument: suspend ReportDeliveryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDeliveryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryInfo = mapped
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("ftywdngtiinychyr")
    public suspend fun format(`value`: Either<String, FormatType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("dtronwkyqeaogvoc")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The format of the report being delivered.
     */
    @JvmName("bquvtbcniuiieepq")
    public fun format(`value`: FormatType) {
        val toBeMapped = Either.ofRight<String, FormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value Report Name.
     */
    @JvmName("pavpfjiabggnlgaa")
    public suspend fun reportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reportName = mapped
    }

    /**
     * @param value Azure Resource Group Name.
     */
    @JvmName("adlampssppmpfgmv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Has schedule information for the report.
     */
    @JvmName("cghblgtdsrlqpykl")
    public suspend fun schedule(`value`: ReportScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Has schedule information for the report.
     */
    @JvmName("uaklkwshxmwekmfj")
    public suspend fun schedule(argument: suspend ReportScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ReportScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    internal fun build(): ReportByResourceGroupNameArgs = ReportByResourceGroupNameArgs(
        definition = definition,
        deliveryInfo = deliveryInfo,
        format = format,
        reportName = reportName,
        resourceGroupName = resourceGroupName,
        schedule = schedule,
    )
}
