@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.BudgetTimePeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The time period that defines the active period of the budget. The budget will evaluate data on or after the startDate and will expire on the endDate.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Required for CategoryType(s): Cost, ReservationUtilization.
 * @property endDate The end date for the budget.
 * - Constraints for **CategoryType: Cost** - No constraints. If not provided, we default this to 10 years from the start date.
 * - Constraints for **CategoryType: ReservationUtilization** - End date cannot be more than 3 years after the start date.
 * @property startDate The start date for the budget.
 * - Constraints for **CategoryType: Cost** - Must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period.
 * - Constraints for **CategoryType: ReservationUtilization** - Must be on or after the current date and less than the end date.
 */
public data class BudgetTimePeriodArgs(
    public val endDate: Output<String>? = null,
    public val startDate: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.BudgetTimePeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.BudgetTimePeriodArgs =
        com.pulumi.azurenative.costmanagement.inputs.BudgetTimePeriodArgs.builder()
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .startDate(startDate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetTimePeriodArgs].
 */
@PulumiTagMarker
public class BudgetTimePeriodArgsBuilder internal constructor() {
    private var endDate: Output<String>? = null

    private var startDate: Output<String>? = null

    /**
     * @param value The end date for the budget.
     * - Constraints for **CategoryType: Cost** - No constraints. If not provided, we default this to 10 years from the start date.
     * - Constraints for **CategoryType: ReservationUtilization** - End date cannot be more than 3 years after the start date.
     */
    @JvmName("qyerotddjlcjybet")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value The start date for the budget.
     * - Constraints for **CategoryType: Cost** - Must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period.
     * - Constraints for **CategoryType: ReservationUtilization** - Must be on or after the current date and less than the end date.
     */
    @JvmName("ccdumbfwpaikggjw")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value The end date for the budget.
     * - Constraints for **CategoryType: Cost** - No constraints. If not provided, we default this to 10 years from the start date.
     * - Constraints for **CategoryType: ReservationUtilization** - End date cannot be more than 3 years after the start date.
     */
    @JvmName("rqhnkvqwnhddhxsu")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value The start date for the budget.
     * - Constraints for **CategoryType: Cost** - Must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period.
     * - Constraints for **CategoryType: ReservationUtilization** - Must be on or after the current date and less than the end date.
     */
    @JvmName("hhbygiaydsxfscxe")
    public suspend fun startDate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    internal fun build(): BudgetTimePeriodArgs = BudgetTimePeriodArgs(
        endDate = endDate,
        startDate = startDate ?: throw PulumiNullFieldException("startDate"),
    )
}
