@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource details of the cost allocation rule
 * @property sourceResources Source resources for cost allocation. At this time, this list can contain no more than one element.
 * @property targetResources Target resources for cost allocation. At this time, this list can contain no more than one element.
 */
public data class CostAllocationRuleDetailsArgs(
    public val sourceResources: Output<List<SourceCostAllocationResourceArgs>>? = null,
    public val targetResources: Output<List<TargetCostAllocationResourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs =
        com.pulumi.azurenative.costmanagement.inputs.CostAllocationRuleDetailsArgs.builder()
            .sourceResources(
                sourceResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetResources(
                targetResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CostAllocationRuleDetailsArgs].
 */
@PulumiTagMarker
public class CostAllocationRuleDetailsArgsBuilder internal constructor() {
    private var sourceResources: Output<List<SourceCostAllocationResourceArgs>>? = null

    private var targetResources: Output<List<TargetCostAllocationResourceArgs>>? = null

    /**
     * @param value Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("pumdmufaukvtqigd")
    public suspend fun sourceResources(`value`: Output<List<SourceCostAllocationResourceArgs>>) {
        this.sourceResources = value
    }

    @JvmName("lmyavfpcwofhwkup")
    public suspend fun sourceResources(vararg values: Output<SourceCostAllocationResourceArgs>) {
        this.sourceResources = Output.all(values.asList())
    }

    /**
     * @param values Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("haigfnuewcjcgumg")
    public suspend fun sourceResources(values: List<Output<SourceCostAllocationResourceArgs>>) {
        this.sourceResources = Output.all(values)
    }

    /**
     * @param value Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("lcbbmiylwquqgkpu")
    public suspend fun targetResources(`value`: Output<List<TargetCostAllocationResourceArgs>>) {
        this.targetResources = value
    }

    @JvmName("dvvimoxekugedlev")
    public suspend fun targetResources(vararg values: Output<TargetCostAllocationResourceArgs>) {
        this.targetResources = Output.all(values.asList())
    }

    /**
     * @param values Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("occhppoqvhcxlhhd")
    public suspend fun targetResources(values: List<Output<TargetCostAllocationResourceArgs>>) {
        this.targetResources = Output.all(values)
    }

    /**
     * @param value Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("uvynnwatxewpjogu")
    public suspend fun sourceResources(`value`: List<SourceCostAllocationResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResources = mapped
    }

    /**
     * @param argument Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("oflwgdfpiydswvkj")
    public suspend
    fun sourceResources(argument: List<suspend SourceCostAllocationResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SourceCostAllocationResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceResources = mapped
    }

    /**
     * @param argument Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("ydcgingrlymwooaj")
    public suspend fun sourceResources(
        vararg
        argument: suspend SourceCostAllocationResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SourceCostAllocationResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceResources = mapped
    }

    /**
     * @param argument Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("gbtaiautvgmqnflk")
    public suspend
    fun sourceResources(argument: suspend SourceCostAllocationResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SourceCostAllocationResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sourceResources = mapped
    }

    /**
     * @param values Source resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("wccxifmqmdcfkkrc")
    public suspend fun sourceResources(vararg values: SourceCostAllocationResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceResources = mapped
    }

    /**
     * @param value Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("yvuhlhkwxhxeykvx")
    public suspend fun targetResources(`value`: List<TargetCostAllocationResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResources = mapped
    }

    /**
     * @param argument Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("jiylybiqejwvtslk")
    public suspend
    fun targetResources(argument: List<suspend TargetCostAllocationResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetCostAllocationResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetResources = mapped
    }

    /**
     * @param argument Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("eluolcibhljesxvn")
    public suspend fun targetResources(
        vararg
        argument: suspend TargetCostAllocationResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TargetCostAllocationResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targetResources = mapped
    }

    /**
     * @param argument Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("pcqopmgmjfvvpqim")
    public suspend
    fun targetResources(argument: suspend TargetCostAllocationResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            TargetCostAllocationResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetResources = mapped
    }

    /**
     * @param values Target resources for cost allocation. At this time, this list can contain no more than one element.
     */
    @JvmName("wlkhmqxcijtxuyco")
    public suspend fun targetResources(vararg values: TargetCostAllocationResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResources = mapped
    }

    internal fun build(): CostAllocationRuleDetailsArgs = CostAllocationRuleDetailsArgs(
        sourceResources = sourceResources,
        targetResources = targetResources,
    )
}
