@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ExportScheduleArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.RecurrenceType
import com.pulumi.azurenative.costmanagement.kotlin.enums.StatusType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The schedule associated with the export.
 * @property recurrence The schedule recurrence.
 * @property recurrencePeriod Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
 * @property status The status of the export's schedule. If 'Inactive', the export's schedule is paused.
 */
public data class ExportScheduleArgs(
    public val recurrence: Output<Either<String, RecurrenceType>>? = null,
    public val recurrencePeriod: Output<ExportRecurrencePeriodArgs>? = null,
    public val status: Output<Either<String, StatusType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ExportScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ExportScheduleArgs =
        com.pulumi.azurenative.costmanagement.inputs.ExportScheduleArgs.builder()
            .recurrence(
                recurrence?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .recurrencePeriod(recurrencePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExportScheduleArgs].
 */
@PulumiTagMarker
public class ExportScheduleArgsBuilder internal constructor() {
    private var recurrence: Output<Either<String, RecurrenceType>>? = null

    private var recurrencePeriod: Output<ExportRecurrencePeriodArgs>? = null

    private var status: Output<Either<String, StatusType>>? = null

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("luctsawkstoahmpv")
    public suspend fun recurrence(`value`: Output<Either<String, RecurrenceType>>) {
        this.recurrence = value
    }

    /**
     * @param value Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
     */
    @JvmName("casjmxgvusdgryfh")
    public suspend fun recurrencePeriod(`value`: Output<ExportRecurrencePeriodArgs>) {
        this.recurrencePeriod = value
    }

    /**
     * @param value The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     */
    @JvmName("ajbhlvstckeqfyuv")
    public suspend fun status(`value`: Output<Either<String, StatusType>>) {
        this.status = value
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("kpmgwuofwhhidmfv")
    public suspend fun recurrence(`value`: Either<String, RecurrenceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("podnpydnragyttpg")
    public fun recurrence(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RecurrenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value The schedule recurrence.
     */
    @JvmName("banfurkhwebkhsml")
    public fun recurrence(`value`: RecurrenceType) {
        val toBeMapped = Either.ofRight<String, RecurrenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
     */
    @JvmName("iehvcavfacrqquus")
    public suspend fun recurrencePeriod(`value`: ExportRecurrencePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrencePeriod = mapped
    }

    /**
     * @param argument Has start and end date of the recurrence. The start date must be in future. If present, the end date must be greater than start date.
     */
    @JvmName("wlftxtdefrbronaf")
    public suspend
    fun recurrencePeriod(argument: suspend ExportRecurrencePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = ExportRecurrencePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.recurrencePeriod = mapped
    }

    /**
     * @param value The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     */
    @JvmName("lwiluqvclnhtextr")
    public suspend fun status(`value`: Either<String, StatusType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     */
    @JvmName("pocduifbkjgxqwyd")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StatusType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status of the export's schedule. If 'Inactive', the export's schedule is paused.
     */
    @JvmName("mtijxmofdqlvpgdv")
    public fun status(`value`: StatusType) {
        val toBeMapped = Either.ofRight<String, StatusType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ExportScheduleArgs = ExportScheduleArgs(
        recurrence = recurrence,
        recurrencePeriod = recurrencePeriod,
        status = status,
    )
}
