@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.KpiPropertiesArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.KpiTypeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Each KPI must contain a 'type' and 'enabled' key.
 * @property enabled show the KPI in the UI?
 * @property id ID of resource related to metric (budget).
 * @property type KPI type (Forecast, Budget).
 */
public data class KpiPropertiesArgs(
    public val enabled: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val type: Output<Either<String, KpiTypeType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.KpiPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.KpiPropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.KpiPropertiesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [KpiPropertiesArgs].
 */
@PulumiTagMarker
public class KpiPropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var type: Output<Either<String, KpiTypeType>>? = null

    /**
     * @param value show the KPI in the UI?
     */
    @JvmName("swotoqkwqaferqhs")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value ID of resource related to metric (budget).
     */
    @JvmName("yhlcwmcgdkqcvudx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value KPI type (Forecast, Budget).
     */
    @JvmName("fhtruuetvauvvlvc")
    public suspend fun type(`value`: Output<Either<String, KpiTypeType>>) {
        this.type = value
    }

    /**
     * @param value show the KPI in the UI?
     */
    @JvmName("kiullbcypcarvouo")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value ID of resource related to metric (budget).
     */
    @JvmName("semrgxkksgbyivjw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value KPI type (Forecast, Budget).
     */
    @JvmName("ipaofquvhapgcbaq")
    public suspend fun type(`value`: Either<String, KpiTypeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value KPI type (Forecast, Budget).
     */
    @JvmName("dnsppkgksnsidxyp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KpiTypeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value KPI type (Forecast, Budget).
     */
    @JvmName("ofmnmvvffbqqdmki")
    public fun type(`value`: KpiTypeType) {
        val toBeMapped = Either.ofRight<String, KpiTypeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): KpiPropertiesArgs = KpiPropertiesArgs(
        enabled = enabled,
        id = id,
        type = type,
    )
}
