@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.NotificationArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.BudgetNotificationOperatorType
import com.pulumi.azurenative.costmanagement.kotlin.enums.CultureCode
import com.pulumi.azurenative.costmanagement.kotlin.enums.Frequency
import com.pulumi.azurenative.costmanagement.kotlin.enums.ThresholdType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The notification associated with a budget.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property contactEmails Email addresses to send the notification to when the threshold is breached. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property contactGroups Subscription or Resource Group scopes only. Action groups to send the notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id.
 *  Supported for CategoryType(s): Cost.
 * @property contactRoles Subscription or Resource Group scopes only. Contact roles to send the notification to when the threshold is breached.
 *  Supported for CategoryType(s): Cost.
 * @property enabled The notification is enabled or not.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property frequency Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
 *  Supported for CategoryType(s): ReservationUtilization.
 * @property locale Language in which the recipient will receive the notification,
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property operator The comparison operator.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  Supported operators for **CategoryType: Cost**
 * - GreaterThan
 * - GreaterThanOrEqualTo
 *  Supported operators for **CategoryType: ReservationUtilization**
 * - LessThan
 * @property threshold Threshold value associated with a notification. It is always percent with a maximum of 2 decimal places.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 *  **CategoryType: Cost** - Must be between 0 and 1000. Notification is sent when the cost exceeded the threshold.
 *  **CategoryType: ReservationUtilization** - Must be between 0 and 100. Notification is sent when a reservation has a utilization percentage below the threshold.
 * @property thresholdType The type of threshold.
 *  Supported for CategoryType(s): Cost.
 */
public data class NotificationArgs(
    public val contactEmails: Output<List<String>>,
    public val contactGroups: Output<List<String>>? = null,
    public val contactRoles: Output<List<String>>? = null,
    public val enabled: Output<Boolean>,
    public val frequency: Output<Either<String, Frequency>>? = null,
    public val locale: Output<Either<String, CultureCode>>? = null,
    public val `operator`: Output<Either<String, BudgetNotificationOperatorType>>,
    public val threshold: Output<Double>,
    public val thresholdType: Output<Either<String, ThresholdType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.NotificationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.NotificationArgs =
        com.pulumi.azurenative.costmanagement.inputs.NotificationArgs.builder()
            .contactEmails(contactEmails.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .contactGroups(contactGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .contactRoles(contactRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .locale(
                locale?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .threshold(threshold.applyValue({ args0 -> args0 }))
            .thresholdType(
                thresholdType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationArgs].
 */
@PulumiTagMarker
public class NotificationArgsBuilder internal constructor() {
    private var contactEmails: Output<List<String>>? = null

    private var contactGroups: Output<List<String>>? = null

    private var contactRoles: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var frequency: Output<Either<String, Frequency>>? = null

    private var locale: Output<Either<String, CultureCode>>? = null

    private var `operator`: Output<Either<String, BudgetNotificationOperatorType>>? = null

    private var threshold: Output<Double>? = null

    private var thresholdType: Output<Either<String, ThresholdType>>? = null

    /**
     * @param value Email addresses to send the notification to when the threshold is breached. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("jnbkiqsceecxtvsl")
    public suspend fun contactEmails(`value`: Output<List<String>>) {
        this.contactEmails = value
    }

    @JvmName("gtqmwbfdehdtncca")
    public suspend fun contactEmails(vararg values: Output<String>) {
        this.contactEmails = Output.all(values.asList())
    }

    /**
     * @param values Email addresses to send the notification to when the threshold is breached. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("gbmpfhycgnusbdmv")
    public suspend fun contactEmails(values: List<Output<String>>) {
        this.contactEmails = Output.all(values)
    }

    /**
     * @param value Subscription or Resource Group scopes only. Action groups to send the notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("ombncsglenyjtxrk")
    public suspend fun contactGroups(`value`: Output<List<String>>) {
        this.contactGroups = value
    }

    @JvmName("mjsyepnfwaeumcym")
    public suspend fun contactGroups(vararg values: Output<String>) {
        this.contactGroups = Output.all(values.asList())
    }

    /**
     * @param values Subscription or Resource Group scopes only. Action groups to send the notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("neruylfbauivxrhi")
    public suspend fun contactGroups(values: List<Output<String>>) {
        this.contactGroups = Output.all(values)
    }

    /**
     * @param value Subscription or Resource Group scopes only. Contact roles to send the notification to when the threshold is breached.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("gqkluehlukvjlbeq")
    public suspend fun contactRoles(`value`: Output<List<String>>) {
        this.contactRoles = value
    }

    @JvmName("wursoktgkugihrnq")
    public suspend fun contactRoles(vararg values: Output<String>) {
        this.contactRoles = Output.all(values.asList())
    }

    /**
     * @param values Subscription or Resource Group scopes only. Contact roles to send the notification to when the threshold is breached.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("hfxggwrtffmekomo")
    public suspend fun contactRoles(values: List<Output<String>>) {
        this.contactRoles = Output.all(values)
    }

    /**
     * @param value The notification is enabled or not.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("qhepxerupkurepmh")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
     *  Supported for CategoryType(s): ReservationUtilization.
     */
    @JvmName("bnrpudsfolvblysk")
    public suspend fun frequency(`value`: Output<Either<String, Frequency>>) {
        this.frequency = value
    }

    /**
     * @param value Language in which the recipient will receive the notification,
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("ckrrvijuqkepysbj")
    public suspend fun locale(`value`: Output<Either<String, CultureCode>>) {
        this.locale = value
    }

    /**
     * @param value The comparison operator.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported operators for **CategoryType: Cost**
     * - GreaterThan
     * - GreaterThanOrEqualTo
     *  Supported operators for **CategoryType: ReservationUtilization**
     * - LessThan
     */
    @JvmName("noxicdhsgbaeghga")
    public suspend fun `operator`(`value`: Output<Either<String, BudgetNotificationOperatorType>>) {
        this.`operator` = value
    }

    /**
     * @param value Threshold value associated with a notification. It is always percent with a maximum of 2 decimal places.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  **CategoryType: Cost** - Must be between 0 and 1000. Notification is sent when the cost exceeded the threshold.
     *  **CategoryType: ReservationUtilization** - Must be between 0 and 100. Notification is sent when a reservation has a utilization percentage below the threshold.
     */
    @JvmName("vvaegynbswedfgke")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value The type of threshold.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("kiblrrgjmbgsyrbp")
    public suspend fun thresholdType(`value`: Output<Either<String, ThresholdType>>) {
        this.thresholdType = value
    }

    /**
     * @param value Email addresses to send the notification to when the threshold is breached. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("onejygsonjbddlcf")
    public suspend fun contactEmails(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactEmails = mapped
    }

    /**
     * @param values Email addresses to send the notification to when the threshold is breached. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("gaeqjhnbphxolxsg")
    public suspend fun contactEmails(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactEmails = mapped
    }

    /**
     * @param value Subscription or Resource Group scopes only. Action groups to send the notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("eeslowpginrhdeai")
    public suspend fun contactGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param values Subscription or Resource Group scopes only. Action groups to send the notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("svghwtbtcttxrvcb")
    public suspend fun contactGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactGroups = mapped
    }

    /**
     * @param value Subscription or Resource Group scopes only. Contact roles to send the notification to when the threshold is breached.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("jsdmmncjkipvvtjw")
    public suspend fun contactRoles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactRoles = mapped
    }

    /**
     * @param values Subscription or Resource Group scopes only. Contact roles to send the notification to when the threshold is breached.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("osdfcardycbaypgg")
    public suspend fun contactRoles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactRoles = mapped
    }

    /**
     * @param value The notification is enabled or not.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("fyywugpoxxywfgwa")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
     *  Supported for CategoryType(s): ReservationUtilization.
     */
    @JvmName("tkkenqnxfmqxluwl")
    public suspend fun frequency(`value`: Either<String, Frequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
     *  Supported for CategoryType(s): ReservationUtilization.
     */
    @JvmName("wvkfewqtlkufmxks")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Frequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Frequency of a notification. Represents how long the notification will be silent after triggering an alert for a threshold breach. If not specified, the frequency will be set by default based on the timeGrain (Weekly when timeGrain: Last7Days, Monthly when timeGrain: Last30Days).
     *  Supported for CategoryType(s): ReservationUtilization.
     */
    @JvmName("yeqwqgqoywrsqrew")
    public fun frequency(`value`: Frequency) {
        val toBeMapped = Either.ofRight<String, Frequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Language in which the recipient will receive the notification,
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("fcycxqtnfsjrwayt")
    public suspend fun locale(`value`: Either<String, CultureCode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value Language in which the recipient will receive the notification,
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("aapegfvvltvrfslo")
    public fun locale(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CultureCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value Language in which the recipient will receive the notification,
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     */
    @JvmName("sxokelwiewylaguy")
    public fun locale(`value`: CultureCode) {
        val toBeMapped = Either.ofRight<String, CultureCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value The comparison operator.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported operators for **CategoryType: Cost**
     * - GreaterThan
     * - GreaterThanOrEqualTo
     *  Supported operators for **CategoryType: ReservationUtilization**
     * - LessThan
     */
    @JvmName("uosnhtgweybwhywc")
    public suspend fun `operator`(`value`: Either<String, BudgetNotificationOperatorType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The comparison operator.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported operators for **CategoryType: Cost**
     * - GreaterThan
     * - GreaterThanOrEqualTo
     *  Supported operators for **CategoryType: ReservationUtilization**
     * - LessThan
     */
    @JvmName("caopntdcklgretor")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BudgetNotificationOperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The comparison operator.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  Supported operators for **CategoryType: Cost**
     * - GreaterThan
     * - GreaterThanOrEqualTo
     *  Supported operators for **CategoryType: ReservationUtilization**
     * - LessThan
     */
    @JvmName("xypbdfuedfffmvcm")
    public fun `operator`(`value`: BudgetNotificationOperatorType) {
        val toBeMapped = Either.ofRight<String, BudgetNotificationOperatorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Threshold value associated with a notification. It is always percent with a maximum of 2 decimal places.
     *  Supported for CategoryType(s): Cost, ReservationUtilization.
     *  **CategoryType: Cost** - Must be between 0 and 1000. Notification is sent when the cost exceeded the threshold.
     *  **CategoryType: ReservationUtilization** - Must be between 0 and 100. Notification is sent when a reservation has a utilization percentage below the threshold.
     */
    @JvmName("ajfkdskhsbjebyuh")
    public suspend fun threshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value The type of threshold.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("fqmbxdyeusmqdgts")
    public suspend fun thresholdType(`value`: Either<String, ThresholdType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value The type of threshold.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("yftjbljwbxhpyuca")
    public fun thresholdType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    /**
     * @param value The type of threshold.
     *  Supported for CategoryType(s): Cost.
     */
    @JvmName("ggggbqtwmlyvfxgs")
    public fun thresholdType(`value`: ThresholdType) {
        val toBeMapped = Either.ofRight<String, ThresholdType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thresholdType = mapped
    }

    internal fun build(): NotificationArgs = NotificationArgs(
        contactEmails = contactEmails ?: throw PulumiNullFieldException("contactEmails"),
        contactGroups = contactGroups,
        contactRoles = contactRoles,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        frequency = frequency,
        locale = locale,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        threshold = threshold ?: throw PulumiNullFieldException("threshold"),
        thresholdType = thresholdType,
    )
}
