@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.NotificationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of the scheduled action notification.
 * @property language Locale of the email.
 * @property message Optional message to be added in the email. Length is limited to 250 characters.
 * @property regionalFormat Regional format used for formatting date/time and currency values in the email.
 * @property subject Subject of the email. Length is limited to 70 characters.
 * @property to Array of email addresses.
 */
public data class NotificationPropertiesArgs(
    public val language: Output<String>? = null,
    public val message: Output<String>? = null,
    public val regionalFormat: Output<String>? = null,
    public val subject: Output<String>,
    public val to: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.NotificationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.NotificationPropertiesArgs =
        com.pulumi.azurenative.costmanagement.inputs.NotificationPropertiesArgs.builder()
            .language(language?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 }))
            .regionalFormat(regionalFormat?.applyValue({ args0 -> args0 }))
            .subject(subject.applyValue({ args0 -> args0 }))
            .to(to.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NotificationPropertiesArgs].
 */
@PulumiTagMarker
public class NotificationPropertiesArgsBuilder internal constructor() {
    private var language: Output<String>? = null

    private var message: Output<String>? = null

    private var regionalFormat: Output<String>? = null

    private var subject: Output<String>? = null

    private var to: Output<List<String>>? = null

    /**
     * @param value Locale of the email.
     */
    @JvmName("siripdtgusqlidgw")
    public suspend fun language(`value`: Output<String>) {
        this.language = value
    }

    /**
     * @param value Optional message to be added in the email. Length is limited to 250 characters.
     */
    @JvmName("enjeroqimolvoanm")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Regional format used for formatting date/time and currency values in the email.
     */
    @JvmName("tikrpnxindbkmfuw")
    public suspend fun regionalFormat(`value`: Output<String>) {
        this.regionalFormat = value
    }

    /**
     * @param value Subject of the email. Length is limited to 70 characters.
     */
    @JvmName("tfamemvreoiicemv")
    public suspend fun subject(`value`: Output<String>) {
        this.subject = value
    }

    /**
     * @param value Array of email addresses.
     */
    @JvmName("msfybnaoweuemkhn")
    public suspend fun to(`value`: Output<List<String>>) {
        this.to = value
    }

    @JvmName("lmspkaxmliynvsgm")
    public suspend fun to(vararg values: Output<String>) {
        this.to = Output.all(values.asList())
    }

    /**
     * @param values Array of email addresses.
     */
    @JvmName("yyfyrrcvjommocbi")
    public suspend fun to(values: List<Output<String>>) {
        this.to = Output.all(values)
    }

    /**
     * @param value Locale of the email.
     */
    @JvmName("yxpulieuqqtbtrts")
    public suspend fun language(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.language = mapped
    }

    /**
     * @param value Optional message to be added in the email. Length is limited to 250 characters.
     */
    @JvmName("haeaahwprgnbnmcf")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Regional format used for formatting date/time and currency values in the email.
     */
    @JvmName("thpdrbfqntnpfdle")
    public suspend fun regionalFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalFormat = mapped
    }

    /**
     * @param value Subject of the email. Length is limited to 70 characters.
     */
    @JvmName("lytyopqtofymayde")
    public suspend fun subject(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subject = mapped
    }

    /**
     * @param value Array of email addresses.
     */
    @JvmName("mosoejvjsggglasw")
    public suspend fun to(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    /**
     * @param values Array of email addresses.
     */
    @JvmName("vcgdmegiigxjsbwp")
    public suspend fun to(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): NotificationPropertiesArgs = NotificationPropertiesArgs(
        language = language,
        message = message,
        regionalFormat = regionalFormat,
        subject = subject ?: throw PulumiNullFieldException("subject"),
        to = to ?: throw PulumiNullFieldException("to"),
    )
}
