@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigAggregationArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.FunctionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The aggregation expression to be used in the report.
 * @property function The name of the aggregation function to use.
 * @property name The name of the column to aggregate.
 */
public data class ReportConfigAggregationArgs(
    public val function: Output<Either<String, FunctionType>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigAggregationArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportConfigAggregationArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigAggregationArgs.builder()
            .function(
                function.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportConfigAggregationArgs].
 */
@PulumiTagMarker
public class ReportConfigAggregationArgsBuilder internal constructor() {
    private var function: Output<Either<String, FunctionType>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The name of the aggregation function to use.
     */
    @JvmName("ipipnovetmjnlset")
    public suspend fun function(`value`: Output<Either<String, FunctionType>>) {
        this.function = value
    }

    /**
     * @param value The name of the column to aggregate.
     */
    @JvmName("hwnvxdtrcnegoxhx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the aggregation function to use.
     */
    @JvmName("uyeuexyxiwxdpjpy")
    public suspend fun function(`value`: Either<String, FunctionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value The name of the aggregation function to use.
     */
    @JvmName("djwmucqpajphisag")
    public fun function(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FunctionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value The name of the aggregation function to use.
     */
    @JvmName("majvjvnalwmsvsou")
    public fun function(`value`: FunctionType) {
        val toBeMapped = Either.ofRight<String, FunctionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value The name of the column to aggregate.
     */
    @JvmName("yncjadoibuagietf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ReportConfigAggregationArgs = ReportConfigAggregationArgs(
        function = function ?: throw PulumiNullFieldException("function"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
