@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ReportGranularityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The definition of data present in the report.
 * @property aggregation Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
 * @property configuration Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
 * @property filter Has filter expression to use in the report.
 * @property granularity The granularity of rows in the report.
 * @property grouping Array of group by expression to use in the report. Report can have up to 2 group by clauses.
 * @property sorting Array of order by expression to use in the report.
 */
public data class ReportConfigDatasetArgs(
    public val aggregation: Output<Map<String, ReportConfigAggregationArgs>>? = null,
    public val configuration: Output<ReportConfigDatasetConfigurationArgs>? = null,
    public val filter: Output<ReportConfigFilterArgs>? = null,
    public val granularity: Output<Either<String, ReportGranularityType>>? = null,
    public val grouping: Output<List<ReportConfigGroupingArgs>>? = null,
    public val sorting: Output<List<ReportConfigSortingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportConfigDatasetArgs.builder()
            .aggregation(
                aggregation?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .granularity(
                granularity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .grouping(
                grouping?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sorting(
                sorting?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReportConfigDatasetArgs].
 */
@PulumiTagMarker
public class ReportConfigDatasetArgsBuilder internal constructor() {
    private var aggregation: Output<Map<String, ReportConfigAggregationArgs>>? = null

    private var configuration: Output<ReportConfigDatasetConfigurationArgs>? = null

    private var filter: Output<ReportConfigFilterArgs>? = null

    private var granularity: Output<Either<String, ReportGranularityType>>? = null

    private var grouping: Output<List<ReportConfigGroupingArgs>>? = null

    private var sorting: Output<List<ReportConfigSortingArgs>>? = null

    /**
     * @param value Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("fvarsykxnfcaypvt")
    public suspend fun aggregation(`value`: Output<Map<String, ReportConfigAggregationArgs>>) {
        this.aggregation = value
    }

    /**
     * @param value Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
     */
    @JvmName("cfbjnxsutswsyqhe")
    public suspend fun configuration(`value`: Output<ReportConfigDatasetConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Has filter expression to use in the report.
     */
    @JvmName("iupbwebtyqrshfun")
    public suspend fun filter(`value`: Output<ReportConfigFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("boxnuhwywhahooqw")
    public suspend fun granularity(`value`: Output<Either<String, ReportGranularityType>>) {
        this.granularity = value
    }

    /**
     * @param value Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("acvrmoaymapfodhn")
    public suspend fun grouping(`value`: Output<List<ReportConfigGroupingArgs>>) {
        this.grouping = value
    }

    @JvmName("eawrbuxmrgsxrhpq")
    public suspend fun grouping(vararg values: Output<ReportConfigGroupingArgs>) {
        this.grouping = Output.all(values.asList())
    }

    /**
     * @param values Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("bejbhksjxeoacryu")
    public suspend fun grouping(values: List<Output<ReportConfigGroupingArgs>>) {
        this.grouping = Output.all(values)
    }

    /**
     * @param value Array of order by expression to use in the report.
     */
    @JvmName("hcaoytdouqxskauk")
    public suspend fun sorting(`value`: Output<List<ReportConfigSortingArgs>>) {
        this.sorting = value
    }

    @JvmName("sgnnyhtqsccpryga")
    public suspend fun sorting(vararg values: Output<ReportConfigSortingArgs>) {
        this.sorting = Output.all(values.asList())
    }

    /**
     * @param values Array of order by expression to use in the report.
     */
    @JvmName("filfmjgocoxnmlyr")
    public suspend fun sorting(values: List<Output<ReportConfigSortingArgs>>) {
        this.sorting = Output.all(values)
    }

    /**
     * @param value Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("fleetpinsnxsbuqw")
    public suspend fun aggregation(`value`: Map<String, ReportConfigAggregationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregation = mapped
    }

    /**
     * @param argument Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("nagenhevnsxyqhko")
    public suspend fun aggregation(
        vararg
        argument: Pair<String, suspend ReportConfigAggregationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ReportConfigAggregationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.aggregation = mapped
    }

    /**
     * @param values Dictionary of aggregation expression to use in the report. The key of each item in the dictionary is the alias for the aggregated column. Report can have up to 2 aggregation clauses.
     */
    @JvmName("fjfksdehpjmxqlhp")
    public fun aggregation(vararg values: Pair<String, ReportConfigAggregationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aggregation = mapped
    }

    /**
     * @param value Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
     */
    @JvmName("ffguqlqtbpteiytn")
    public suspend fun configuration(`value`: ReportConfigDatasetConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Has configuration information for the data in the report. The configuration will be ignored if aggregation and grouping are provided.
     */
    @JvmName("raypcnqslsroivgj")
    public suspend
    fun configuration(argument: suspend ReportConfigDatasetConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ReportConfigDatasetConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Has filter expression to use in the report.
     */
    @JvmName("sxkrkrssdmyemchl")
    public suspend fun filter(`value`: ReportConfigFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Has filter expression to use in the report.
     */
    @JvmName("qecmjsrhooxvycph")
    public suspend fun filter(argument: suspend ReportConfigFilterArgsBuilder.() -> Unit) {
        val toBeMapped = ReportConfigFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("spsnqpvskaakvsqk")
    public suspend fun granularity(`value`: Either<String, ReportGranularityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("kbwbhndqnjdemppl")
    public fun granularity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReportGranularityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value The granularity of rows in the report.
     */
    @JvmName("otkgbwwxtsdcqoqa")
    public fun granularity(`value`: ReportGranularityType) {
        val toBeMapped = Either.ofRight<String, ReportGranularityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.granularity = mapped
    }

    /**
     * @param value Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("clijjaekahkcgwcg")
    public suspend fun grouping(`value`: List<ReportConfigGroupingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param argument Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("cqqfefqpvxhgcbst")
    public suspend fun grouping(argument: List<suspend ReportConfigGroupingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportConfigGroupingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param argument Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("jsguhyvgjiqsmkbg")
    public suspend fun grouping(vararg argument: suspend ReportConfigGroupingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportConfigGroupingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param argument Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("lbxbiplxtlnrivmw")
    public suspend fun grouping(argument: suspend ReportConfigGroupingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportConfigGroupingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.grouping = mapped
    }

    /**
     * @param values Array of group by expression to use in the report. Report can have up to 2 group by clauses.
     */
    @JvmName("amayhjsfbkwhomfg")
    public suspend fun grouping(vararg values: ReportConfigGroupingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grouping = mapped
    }

    /**
     * @param value Array of order by expression to use in the report.
     */
    @JvmName("pnvpmhfjgaqukioj")
    public suspend fun sorting(`value`: List<ReportConfigSortingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sorting = mapped
    }

    /**
     * @param argument Array of order by expression to use in the report.
     */
    @JvmName("solmgtimjimndpju")
    public suspend fun sorting(argument: List<suspend ReportConfigSortingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReportConfigSortingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sorting = mapped
    }

    /**
     * @param argument Array of order by expression to use in the report.
     */
    @JvmName("xebdkyqtcpbrifwa")
    public suspend fun sorting(vararg argument: suspend ReportConfigSortingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReportConfigSortingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sorting = mapped
    }

    /**
     * @param argument Array of order by expression to use in the report.
     */
    @JvmName("vwksrpcinpdiigco")
    public suspend fun sorting(argument: suspend ReportConfigSortingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReportConfigSortingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sorting = mapped
    }

    /**
     * @param values Array of order by expression to use in the report.
     */
    @JvmName("madffuvotgxocydq")
    public suspend fun sorting(vararg values: ReportConfigSortingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sorting = mapped
    }

    internal fun build(): ReportConfigDatasetArgs = ReportConfigDatasetArgs(
        aggregation = aggregation,
        configuration = configuration,
        filter = filter,
        granularity = granularity,
        grouping = grouping,
        sorting = sorting,
    )
}
