@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportDefinitionArgs.builder
import com.pulumi.azurenative.costmanagement.kotlin.enums.ReportType
import com.pulumi.azurenative.costmanagement.kotlin.enums.TimeframeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The definition of a report.
 * @property dataset Has definition for data in this report.
 * @property timePeriod Has time period for pulling data for the report.
 * @property timeframe The time frame for pulling data for the report. If custom, then a specific time period must be provided.
 * @property type The type of the report.
 */
public data class ReportDefinitionArgs(
    public val dataset: Output<ReportDatasetArgs>? = null,
    public val timePeriod: Output<ReportTimePeriodArgs>? = null,
    public val timeframe: Output<Either<String, TimeframeType>>,
    public val type: Output<Either<String, ReportType>>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportDefinitionArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportDefinitionArgs.builder()
            .dataset(dataset?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timePeriod(timePeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeframe(
                timeframe.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReportDefinitionArgs].
 */
@PulumiTagMarker
public class ReportDefinitionArgsBuilder internal constructor() {
    private var dataset: Output<ReportDatasetArgs>? = null

    private var timePeriod: Output<ReportTimePeriodArgs>? = null

    private var timeframe: Output<Either<String, TimeframeType>>? = null

    private var type: Output<Either<String, ReportType>>? = null

    /**
     * @param value Has definition for data in this report.
     */
    @JvmName("uhieeoockbgyhmew")
    public suspend fun dataset(`value`: Output<ReportDatasetArgs>) {
        this.dataset = value
    }

    /**
     * @param value Has time period for pulling data for the report.
     */
    @JvmName("qqgmwcafbkgfbcos")
    public suspend fun timePeriod(`value`: Output<ReportTimePeriodArgs>) {
        this.timePeriod = value
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("menmcjiuheatelpm")
    public suspend fun timeframe(`value`: Output<Either<String, TimeframeType>>) {
        this.timeframe = value
    }

    /**
     * @param value The type of the report.
     */
    @JvmName("sjroejflakhqsmht")
    public suspend fun type(`value`: Output<Either<String, ReportType>>) {
        this.type = value
    }

    /**
     * @param value Has definition for data in this report.
     */
    @JvmName("kirimxflkghsybhi")
    public suspend fun dataset(`value`: ReportDatasetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param argument Has definition for data in this report.
     */
    @JvmName("dareqvnuncsmopyo")
    public suspend fun dataset(argument: suspend ReportDatasetArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDatasetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataset = mapped
    }

    /**
     * @param value Has time period for pulling data for the report.
     */
    @JvmName("seciwiobmioacqcc")
    public suspend fun timePeriod(`value`: ReportTimePeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timePeriod = mapped
    }

    /**
     * @param argument Has time period for pulling data for the report.
     */
    @JvmName("atrwvhlthpfbxlgd")
    public suspend fun timePeriod(argument: suspend ReportTimePeriodArgsBuilder.() -> Unit) {
        val toBeMapped = ReportTimePeriodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timePeriod = mapped
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("kugkitnrehgdgblb")
    public suspend fun timeframe(`value`: Either<String, TimeframeType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("fhmwyuovnfojunfa")
    public fun timeframe(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeframeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The time frame for pulling data for the report. If custom, then a specific time period must be provided.
     */
    @JvmName("itywbermvtfqrrhu")
    public fun timeframe(`value`: TimeframeType) {
        val toBeMapped = Either.ofRight<String, TimeframeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeframe = mapped
    }

    /**
     * @param value The type of the report.
     */
    @JvmName("jffaqddvgavguxji")
    public suspend fun type(`value`: Either<String, ReportType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the report.
     */
    @JvmName("subfnikypumeyedq")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the report.
     */
    @JvmName("nvuqiswqvnnyykql")
    public fun type(`value`: ReportType) {
        val toBeMapped = Either.ofRight<String, ReportType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReportDefinitionArgs = ReportDefinitionArgs(
        dataset = dataset,
        timePeriod = timePeriod,
        timeframe = timeframe ?: throw PulumiNullFieldException("timeframe"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
