@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.inputs

import com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The delivery information associated with a report.
 * @property destination Has destination for the report being delivered.
 */
public data class ReportDeliveryInfoArgs(
    public val destination: Output<ReportDeliveryDestinationArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryInfoArgs =
        com.pulumi.azurenative.costmanagement.inputs.ReportDeliveryInfoArgs.builder()
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ReportDeliveryInfoArgs].
 */
@PulumiTagMarker
public class ReportDeliveryInfoArgsBuilder internal constructor() {
    private var destination: Output<ReportDeliveryDestinationArgs>? = null

    /**
     * @param value Has destination for the report being delivered.
     */
    @JvmName("rchskevwvhbwnpwx")
    public suspend fun destination(`value`: Output<ReportDeliveryDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Has destination for the report being delivered.
     */
    @JvmName("ciupatlwatqecqpj")
    public suspend fun destination(`value`: ReportDeliveryDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Has destination for the report being delivered.
     */
    @JvmName("gvmjdoydurxqwnee")
    public suspend
    fun destination(argument: suspend ReportDeliveryDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ReportDeliveryDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    internal fun build(): ReportDeliveryInfoArgs = ReportDeliveryInfoArgs(
        destination = destination ?: throw PulumiNullFieldException("destination"),
    )
}
