@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Suppress

/**
 * The Dimensions or Tags to filter a budget by.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * @property dimensions Has comparison expression for a dimension.
 *  Supported for CategoryType(s): Cost, ReservationUtilization.
 * Supported dimension names for **CategoryType: ReservationUtilization**
 * - ReservationId
 * - ReservedResourceType
 * @property tags Has comparison expression for a tag.
 *  Supported for CategoryType(s): Cost.
 */
public data class BudgetFilterPropertiesResponse(
    public val dimensions: BudgetComparisonExpressionResponse? = null,
    public val tags: BudgetComparisonExpressionResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.BudgetFilterPropertiesResponse):
            BudgetFilterPropertiesResponse = BudgetFilterPropertiesResponse(
            dimensions = javaType.dimensions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.BudgetComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
