@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Target resources and allocation
 * @property name Target resource for cost allocation
 * @property percentage Percentage of source cost to allocate to this resource. This value can be specified to two decimal places and the total percentage of all resources in this rule must sum to 100.00.
 */
public data class CostAllocationProportionResponse(
    public val name: String,
    public val percentage: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.CostAllocationProportionResponse):
            CostAllocationProportionResponse = CostAllocationProportionResponse(
            name = javaType.name(),
            percentage = javaType.percentage(),
        )
    }
}
