@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Connector model definition
 * @property collection Collection information
 * @property createdOn Connector definition creation datetime
 * @property credentialsKey Credentials authentication key (eg AWS ARN)
 * @property displayName Connector DisplayName (defaults to Name)
 * @property id Connector id
 * @property kind Connector kind (eg aws)
 * @property location Connector location
 * @property modifiedOn Connector last modified datetime
 * @property name Connector name
 * @property providerAccountId Connector providerAccountId (determined from credentials)
 * @property reportId Identifying source report. (For AWS this is a CUR report name, defined with Daily and with Resources)
 * @property status Connector status
 * @property tags Resource tags.
 * @property type Connector type
 */
public data class GetConnectorResult(
    public val collection: ConnectorCollectionInfoResponse,
    public val createdOn: String,
    public val credentialsKey: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val modifiedOn: String,
    public val name: String,
    public val providerAccountId: String,
    public val reportId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.GetConnectorResult):
            GetConnectorResult = GetConnectorResult(
            collection = javaType.collection().let({ args0 ->
                com.pulumi.azurenative.costmanagement.kotlin.outputs.ConnectorCollectionInfoResponse.Companion.toKotlin(args0)
            }),
            createdOn = javaType.createdOn(),
            credentialsKey = javaType.credentialsKey().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            modifiedOn = javaType.modifiedOn(),
            name = javaType.name(),
            providerAccountId = javaType.providerAccountId(),
            reportId = javaType.reportId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
