@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the scheduled action notification.
 * @property language Locale of the email.
 * @property message Optional message to be added in the email. Length is limited to 250 characters.
 * @property regionalFormat Regional format used for formatting date/time and currency values in the email.
 * @property subject Subject of the email. Length is limited to 70 characters.
 * @property to Array of email addresses.
 */
public data class NotificationPropertiesResponse(
    public val language: String? = null,
    public val message: String? = null,
    public val regionalFormat: String? = null,
    public val subject: String,
    public val to: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.NotificationPropertiesResponse):
            NotificationPropertiesResponse = NotificationPropertiesResponse(
            language = javaType.language().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            regionalFormat = javaType.regionalFormat().map({ args0 -> args0 }).orElse(null),
            subject = javaType.subject(),
            to = javaType.to().map({ args0 -> args0 }),
        )
    }
}
