@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The order by expression to be used in the report.
 * @property direction Direction of sort.
 * @property name The name of the column to sort.
 */
public data class ReportConfigSortingResponse(
    public val direction: String? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportConfigSortingResponse):
            ReportConfigSortingResponse = ReportConfigSortingResponse(
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
