@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The filter expression to be used in the report.
 * @property and The logical "AND" expression. Must have at least 2 items.
 * @property dimension Has comparison expression for a dimension
 * @property not The logical "NOT" expression.
 * @property or The logical "OR" expression. Must have at least 2 items.
 * @property tag Has comparison expression for a tag
 */
public data class ReportFilterResponse(
    public val and: List<ReportFilterResponse>? = null,
    public val dimension: ReportComparisonExpressionResponse? = null,
    public val not: ReportFilterResponse? = null,
    public val or: List<ReportFilterResponse>? = null,
    public val tag: ReportComparisonExpressionResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.ReportFilterResponse):
            ReportFilterResponse = ReportFilterResponse(
            and = javaType.and().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportFilterResponse.Companion.toKotlin(args0)
                })
            }),
            dimension = javaType.dimension().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            not = javaType.not().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            or = javaType.or().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportFilterResponse.Companion.toKotlin(args0)
                })
            }),
            tag = javaType.tag().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.costmanagement.kotlin.outputs.ReportComparisonExpressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
