@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.costmanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the schedule.
 * @property dayOfMonth UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
 * @property daysOfWeek Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
 * @property endDate The end date and time of the scheduled action (UTC).
 * @property frequency Frequency of the schedule.
 * @property hourOfDay UTC time at which cost analysis data will be emailed.
 * @property startDate The start date and time of the scheduled action (UTC).
 * @property weeksOfMonth Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
 */
public data class SchedulePropertiesResponse(
    public val dayOfMonth: Int? = null,
    public val daysOfWeek: List<String>? = null,
    public val endDate: String,
    public val frequency: String,
    public val hourOfDay: Int? = null,
    public val startDate: String,
    public val weeksOfMonth: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.costmanagement.outputs.SchedulePropertiesResponse):
            SchedulePropertiesResponse = SchedulePropertiesResponse(
            dayOfMonth = javaType.dayOfMonth().map({ args0 -> args0 }).orElse(null),
            daysOfWeek = javaType.daysOfWeek().map({ args0 -> args0 }),
            endDate = javaType.endDate(),
            frequency = javaType.frequency(),
            hourOfDay = javaType.hourOfDay().map({ args0 -> args0 }).orElse(null),
            startDate = javaType.startDate(),
            weeksOfMonth = javaType.weeksOfMonth().map({ args0 -> args0 }),
        )
    }
}
