@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingPropertiesResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.ConnectorMappingPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConnectorMapping].
 */
@PulumiTagMarker
public class ConnectorMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorMappingArgs = ConnectorMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorMappingArgsBuilder.() -> Unit) {
        val builder = ConnectorMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectorMapping {
        val builtJavaResource =
            com.pulumi.azurenative.customerinsights.ConnectorMapping(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectorMapping(builtJavaResource)
    }
}

/**
 * The connector mapping resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### ConnectorMappings_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connectorMapping = new AzureNative.CustomerInsights.ConnectorMapping("connectorMapping", new()
 *     {
 *         ConnectorName = "testConnector8858",
 *         Description = "Test mapping",
 *         DisplayName = "testMapping12491",
 *         EntityType = AzureNative.CustomerInsights.EntityTypes.Interaction,
 *         EntityTypeName = "TestInteractionType2967",
 *         HubName = "sdkTestHub",
 *         MappingName = "testMapping12491",
 *         MappingProperties = new AzureNative.CustomerInsights.Inputs.ConnectorMappingPropertiesArgs
 *         {
 *             Availability = new AzureNative.CustomerInsights.Inputs.ConnectorMappingAvailabilityArgs
 *             {
 *                 Frequency = AzureNative.CustomerInsights.FrequencyTypes.Hour,
 *                 Interval = 5,
 *             },
 *             CompleteOperation = new AzureNative.CustomerInsights.Inputs.ConnectorMappingCompleteOperationArgs
 *             {
 *                 CompletionOperationType = AzureNative.CustomerInsights.CompletionOperationTypes.DeleteFile,
 *                 DestinationFolder = "fakePath",
 *             },
 *             ErrorManagement = new AzureNative.CustomerInsights.Inputs.ConnectorMappingErrorManagementArgs
 *             {
 *                 ErrorLimit = 10,
 *                 ErrorManagementType = AzureNative.CustomerInsights.ErrorManagementTypes.StopImport,
 *             },
 *             FileFilter = "unknown",
 *             FolderPath = "http://sample.dne/file",
 *             Format = new AzureNative.CustomerInsights.Inputs.ConnectorMappingFormatArgs
 *             {
 *                 ColumnDelimiter = "|",
 *                 FormatType = AzureNative.CustomerInsights.FormatTypes.TextFormat,
 *             },
 *             HasHeader = false,
 *             Structure = new[]
 *             {
 *                 new AzureNative.CustomerInsights.Inputs.ConnectorMappingStructureArgs
 *                 {
 *                     ColumnName = "unknown1",
 *                     IsEncrypted = false,
 *                     PropertyName = "unknwon1",
 *                 },
 *                 new AzureNative.CustomerInsights.Inputs.ConnectorMappingStructureArgs
 *                 {
 *                     ColumnName = "unknown2",
 *                     IsEncrypted = true,
 *                     PropertyName = "unknwon2",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewConnectorMapping(ctx, "connectorMapping", &customerinsights.ConnectorMappingArgs{
 * 			ConnectorName:  pulumi.String("testConnector8858"),
 * 			Description:    pulumi.String("Test mapping"),
 * 			DisplayName:    pulumi.String("testMapping12491"),
 * 			EntityType:     customerinsights.EntityTypesInteraction,
 * 			EntityTypeName: pulumi.String("TestInteractionType2967"),
 * 			HubName:        pulumi.String("sdkTestHub"),
 * 			MappingName:    pulumi.String("testMapping12491"),
 * 			MappingProperties: &customerinsights.ConnectorMappingPropertiesArgs{
 * 				Availability: &customerinsights.ConnectorMappingAvailabilityArgs{
 * 					Frequency: customerinsights.FrequencyTypesHour,
 * 					Interval:  pulumi.Int(5),
 * 				},
 * 				CompleteOperation: &customerinsights.ConnectorMappingCompleteOperationArgs{
 * 					CompletionOperationType: customerinsights.CompletionOperationTypesDeleteFile,
 * 					DestinationFolder:       pulumi.String("fakePath"),
 * 				},
 * 				ErrorManagement: &customerinsights.ConnectorMappingErrorManagementArgs{
 * 					ErrorLimit:          pulumi.Int(10),
 * 					ErrorManagementType: customerinsights.ErrorManagementTypesStopImport,
 * 				},
 * 				FileFilter: pulumi.String("unknown"),
 * 				FolderPath: pulumi.String("http://sample.dne/file"),
 * 				Format: &customerinsights.ConnectorMappingFormatArgs{
 * 					ColumnDelimiter: pulumi.String("|"),
 * 					FormatType:      customerinsights.FormatTypesTextFormat,
 * 				},
 * 				HasHeader: pulumi.Bool(false),
 * 				Structure: customerinsights.ConnectorMappingStructureArray{
 * 					&customerinsights.ConnectorMappingStructureArgs{
 * 						ColumnName:   pulumi.String("unknown1"),
 * 						IsEncrypted:  pulumi.Bool(false),
 * 						PropertyName: pulumi.String("unknwon1"),
 * 					},
 * 					&customerinsights.ConnectorMappingStructureArgs{
 * 						ColumnName:   pulumi.String("unknown2"),
 * 						IsEncrypted:  pulumi.Bool(true),
 * 						PropertyName: pulumi.String("unknwon2"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.ConnectorMapping;
 * import com.pulumi.azurenative.customerinsights.ConnectorMappingArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingPropertiesArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingAvailabilityArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingCompleteOperationArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingErrorManagementArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connectorMapping = new ConnectorMapping("connectorMapping", ConnectorMappingArgs.builder()
 *             .connectorName("testConnector8858")
 *             .description("Test mapping")
 *             .displayName("testMapping12491")
 *             .entityType("Interaction")
 *             .entityTypeName("TestInteractionType2967")
 *             .hubName("sdkTestHub")
 *             .mappingName("testMapping12491")
 *             .mappingProperties(ConnectorMappingPropertiesArgs.builder()
 *                 .availability(ConnectorMappingAvailabilityArgs.builder()
 *                     .frequency("Hour")
 *                     .interval(5)
 *                     .build())
 *                 .completeOperation(ConnectorMappingCompleteOperationArgs.builder()
 *                     .completionOperationType("DeleteFile")
 *                     .destinationFolder("fakePath")
 *                     .build())
 *                 .errorManagement(ConnectorMappingErrorManagementArgs.builder()
 *                     .errorLimit(10)
 *                     .errorManagementType("StopImport")
 *                     .build())
 *                 .fileFilter("unknown")
 *                 .folderPath("http://sample.dne/file")
 *                 .format(ConnectorMappingFormatArgs.builder()
 *                     .columnDelimiter("|")
 *                     .formatType("TextFormat")
 *                     .build())
 *                 .hasHeader(false)
 *                 .structure(
 *                     ConnectorMappingStructureArgs.builder()
 *                         .columnName("unknown1")
 *                         .isEncrypted(false)
 *                         .propertyName("unknwon1")
 *                         .build(),
 *                     ConnectorMappingStructureArgs.builder()
 *                         .columnName("unknown2")
 *                         .isEncrypted(true)
 *                         .propertyName("unknwon2")
 *                         .build())
 *                 .build())
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:ConnectorMapping sdkTestHub/testConnector8858/testMapping12491 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/connectors/{connectorName}/mappings/{mappingName}
 * ```
 */
public class ConnectorMapping internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.ConnectorMapping,
) : KotlinCustomResource(javaResource, ConnectorMappingMapper) {
    /**
     * The connector mapping name
     */
    public val connectorMappingName: Output<String>
        get() = javaResource.connectorMappingName().applyValue({ args0 -> args0 })

    /**
     * The connector name.
     */
    public val connectorName: Output<String>
        get() = javaResource.connectorName().applyValue({ args0 -> args0 })

    /**
     * Type of connector.
     */
    public val connectorType: Output<String>?
        get() = javaResource.connectorType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The created time.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * The DataFormat ID.
     */
    public val dataFormatId: Output<String>
        get() = javaResource.dataFormatId().applyValue({ args0 -> args0 })

    /**
     * The description of the connector mapping.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name for the connector mapping.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines which entity type the file should map to.
     */
    public val entityType: Output<String>
        get() = javaResource.entityType().applyValue({ args0 -> args0 })

    /**
     * The mapping entity name.
     */
    public val entityTypeName: Output<String>
        get() = javaResource.entityTypeName().applyValue({ args0 -> args0 })

    /**
     * The last modified time.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The properties of the mapping.
     */
    public val mappingProperties: Output<ConnectorMappingPropertiesResponse>
        get() = javaResource.mappingProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The next run time based on customer's settings.
     */
    public val nextRunTime: Output<String>
        get() = javaResource.nextRunTime().applyValue({ args0 -> args0 })

    /**
     * The RunId.
     */
    public val runId: Output<String>
        get() = javaResource.runId().applyValue({ args0 -> args0 })

    /**
     * State of connector mapping.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectorMappingMapper : ResourceMapper<ConnectorMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.ConnectorMapping::class == javaResource::class

    override fun map(javaResource: Resource): ConnectorMapping = ConnectorMapping(
        javaResource as
            com.pulumi.azurenative.customerinsights.ConnectorMapping,
    )
}

/**
 * @see [ConnectorMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectorMapping].
 */
public suspend fun connectorMapping(
    name: String,
    block: suspend ConnectorMappingResourceBuilder.() -> Unit,
): ConnectorMapping {
    val builder = ConnectorMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectorMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectorMapping(name: String): ConnectorMapping {
    val builder = ConnectorMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
