@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.HubBillingInfoFormatResponse
import com.pulumi.azurenative.customerinsights.kotlin.outputs.HubBillingInfoFormatResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Hub].
 */
@PulumiTagMarker
public class HubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HubArgs = HubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HubArgsBuilder.() -> Unit) {
        val builder = HubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Hub {
        val builtJavaResource = com.pulumi.azurenative.customerinsights.Hub(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Hub(builtJavaResource)
    }
}

/**
 * Hub resource.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Hubs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hub = new AzureNative.CustomerInsights.Hub("hub", new()
 *     {
 *         HubBillingInfo = new AzureNative.CustomerInsights.Inputs.HubBillingInfoFormatArgs
 *         {
 *             MaxUnits = 5,
 *             MinUnits = 1,
 *             SkuName = "B0",
 *         },
 *         HubName = "sdkTestHub",
 *         Location = "West US",
 *         ResourceGroupName = "TestHubRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewHub(ctx, "hub", &customerinsights.HubArgs{
 * 			HubBillingInfo: &customerinsights.HubBillingInfoFormatArgs{
 * 				MaxUnits: pulumi.Int(5),
 * 				MinUnits: pulumi.Int(1),
 * 				SkuName:  pulumi.String("B0"),
 * 			},
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Hub;
 * import com.pulumi.azurenative.customerinsights.HubArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.HubBillingInfoFormatArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hub = new Hub("hub", HubArgs.builder()
 *             .hubBillingInfo(HubBillingInfoFormatArgs.builder()
 *                 .maxUnits(5)
 *                 .minUnits(1)
 *                 .skuName("B0")
 *                 .build())
 *             .hubName("sdkTestHub")
 *             .location("West US")
 *             .resourceGroupName("TestHubRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Hub testHub2839 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}
 * ```
 */
public class Hub internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Hub,
) : KotlinCustomResource(javaResource, HubMapper) {
    /**
     * API endpoint URL of the hub.
     */
    public val apiEndpoint: Output<String>
        get() = javaResource.apiEndpoint().applyValue({ args0 -> args0 })

    /**
     * Billing settings of the hub.
     */
    public val hubBillingInfo: Output<HubBillingInfoFormatResponse>?
        get() = javaResource.hubBillingInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the hub.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The bit flags for enabled hub features. Bit 0 is set to 1 indicates graph is enabled, or disabled if set to 0. Bit 1 is set to 1 indicates the hub is disabled, or enabled if set to 0.
     */
    public val tenantFeatures: Output<Int>?
        get() = javaResource.tenantFeatures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Web endpoint URL of the hub.
     */
    public val webEndpoint: Output<String>
        get() = javaResource.webEndpoint().applyValue({ args0 -> args0 })
}

public object HubMapper : ResourceMapper<Hub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Hub::class == javaResource::class

    override fun map(javaResource: Resource): Hub = Hub(
        javaResource as
            com.pulumi.azurenative.customerinsights.Hub,
    )
}

/**
 * @see [Hub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Hub].
 */
public suspend fun hub(name: String, block: suspend HubResourceBuilder.() -> Unit): Hub {
    val builder = HubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Hub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hub(name: String): Hub {
    val builder = HubResourceBuilder()
    builder.name(name)
    return builder.build()
}
