@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.KpiArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.CalculationWindowTypes
import com.pulumi.azurenative.customerinsights.kotlin.enums.EntityTypes
import com.pulumi.azurenative.customerinsights.kotlin.enums.KpiFunctions
import com.pulumi.azurenative.customerinsights.kotlin.inputs.KpiAliasArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.KpiAliasArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.KpiExtractArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.KpiExtractArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.KpiThresholdsArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.KpiThresholdsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The KPI resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Kpi_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kpi = new AzureNative.CustomerInsights.Kpi("kpi", new()
 *     {
 *         Aliases = new[]
 *         {
 *             new AzureNative.CustomerInsights.Inputs.KpiAliasArgs
 *             {
 *                 AliasName = "alias",
 *                 Expression = "Id+4",
 *             },
 *         },
 *         CalculationWindow = AzureNative.CustomerInsights.CalculationWindowTypes.Day,
 *         Description =
 *         {
 *             { "en-us", "Kpi Description" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "Kpi DisplayName" },
 *         },
 *         EntityType = AzureNative.CustomerInsights.EntityTypes.Profile,
 *         EntityTypeName = "testProfile2327128",
 *         Expression = "SavingAccountBalance",
 *         Function = AzureNative.CustomerInsights.KpiFunctions.Sum,
 *         GroupBy = new[]
 *         {
 *             "SavingAccountBalance",
 *         },
 *         HubName = "sdkTestHub",
 *         KpiName = "kpiTest45453647",
 *         ResourceGroupName = "TestHubRG",
 *         ThresHolds = new AzureNative.CustomerInsights.Inputs.KpiThresholdsArgs
 *         {
 *             IncreasingKpi = true,
 *             LowerLimit = 5,
 *             UpperLimit = 50,
 *         },
 *         Unit = "unit",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewKpi(ctx, "kpi", &customerinsights.KpiArgs{
 * 			Aliases: customerinsights.KpiAliasArray{
 * 				&customerinsights.KpiAliasArgs{
 * 					AliasName:  pulumi.String("alias"),
 * 					Expression: pulumi.String("Id+4"),
 * 				},
 * 			},
 * 			CalculationWindow: customerinsights.CalculationWindowTypesDay,
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("Kpi Description"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("Kpi DisplayName"),
 * 			},
 * 			EntityType:     customerinsights.EntityTypesProfile,
 * 			EntityTypeName: pulumi.String("testProfile2327128"),
 * 			Expression:     pulumi.String("SavingAccountBalance"),
 * 			Function:       customerinsights.KpiFunctionsSum,
 * 			GroupBy: pulumi.StringArray{
 * 				pulumi.String("SavingAccountBalance"),
 * 			},
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			KpiName:           pulumi.String("kpiTest45453647"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 			ThresHolds: &customerinsights.KpiThresholdsArgs{
 * 				IncreasingKpi: pulumi.Bool(true),
 * 				LowerLimit:    pulumi.Float64(5),
 * 				UpperLimit:    pulumi.Float64(50),
 * 			},
 * 			Unit: pulumi.String("unit"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Kpi;
 * import com.pulumi.azurenative.customerinsights.KpiArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.KpiAliasArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.KpiThresholdsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kpi = new Kpi("kpi", KpiArgs.builder()
 *             .aliases(KpiAliasArgs.builder()
 *                 .aliasName("alias")
 *                 .expression("Id+4")
 *                 .build())
 *             .calculationWindow("Day")
 *             .description(Map.of("en-us", "Kpi Description"))
 *             .displayName(Map.of("en-us", "Kpi DisplayName"))
 *             .entityType("Profile")
 *             .entityTypeName("testProfile2327128")
 *             .expression("SavingAccountBalance")
 *             .function("Sum")
 *             .groupBy("SavingAccountBalance")
 *             .hubName("sdkTestHub")
 *             .kpiName("kpiTest45453647")
 *             .resourceGroupName("TestHubRG")
 *             .thresHolds(KpiThresholdsArgs.builder()
 *                 .increasingKpi(true)
 *                 .lowerLimit(5)
 *                 .upperLimit(50)
 *                 .build())
 *             .unit("unit")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Kpi sdkTestHub/kpiTest45453647 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}
 * ```
 * @property aliases The aliases.
 * @property calculationWindow The calculation window.
 * @property calculationWindowFieldName Name of calculation window field.
 * @property description Localized description for the KPI.
 * @property displayName Localized display name for the KPI.
 * @property entityType The mapping entity type.
 * @property entityTypeName The mapping entity name.
 * @property expression The computation expression for the KPI.
 * @property extracts The KPI extracts.
 * @property filter The filter expression for the KPI.
 * @property function The computation function for the KPI.
 * @property groupBy the group by properties for the KPI.
 * @property hubName The name of the hub.
 * @property kpiName The name of the KPI.
 * @property resourceGroupName The name of the resource group.
 * @property thresHolds The KPI thresholds.
 * @property unit The unit of measurement for the KPI.
 */
public data class KpiArgs(
    public val aliases: Output<List<KpiAliasArgs>>? = null,
    public val calculationWindow: Output<CalculationWindowTypes>? = null,
    public val calculationWindowFieldName: Output<String>? = null,
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val entityType: Output<EntityTypes>? = null,
    public val entityTypeName: Output<String>? = null,
    public val expression: Output<String>? = null,
    public val extracts: Output<List<KpiExtractArgs>>? = null,
    public val filter: Output<String>? = null,
    public val function: Output<KpiFunctions>? = null,
    public val groupBy: Output<List<String>>? = null,
    public val hubName: Output<String>? = null,
    public val kpiName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val thresHolds: Output<KpiThresholdsArgs>? = null,
    public val unit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.KpiArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.KpiArgs =
        com.pulumi.azurenative.customerinsights.KpiArgs.builder()
            .aliases(
                aliases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .calculationWindow(calculationWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .calculationWindowFieldName(calculationWindowFieldName?.applyValue({ args0 -> args0 }))
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .entityType(entityType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .entityTypeName(entityTypeName?.applyValue({ args0 -> args0 }))
            .expression(expression?.applyValue({ args0 -> args0 }))
            .extracts(
                extracts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .filter(filter?.applyValue({ args0 -> args0 }))
            .function(function?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .groupBy(groupBy?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .kpiName(kpiName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .thresHolds(thresHolds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KpiArgs].
 */
@PulumiTagMarker
public class KpiArgsBuilder internal constructor() {
    private var aliases: Output<List<KpiAliasArgs>>? = null

    private var calculationWindow: Output<CalculationWindowTypes>? = null

    private var calculationWindowFieldName: Output<String>? = null

    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var entityType: Output<EntityTypes>? = null

    private var entityTypeName: Output<String>? = null

    private var expression: Output<String>? = null

    private var extracts: Output<List<KpiExtractArgs>>? = null

    private var filter: Output<String>? = null

    private var function: Output<KpiFunctions>? = null

    private var groupBy: Output<List<String>>? = null

    private var hubName: Output<String>? = null

    private var kpiName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var thresHolds: Output<KpiThresholdsArgs>? = null

    private var unit: Output<String>? = null

    /**
     * @param value The aliases.
     */
    @JvmName("otxigdkwdpqopbae")
    public suspend fun aliases(`value`: Output<List<KpiAliasArgs>>) {
        this.aliases = value
    }

    @JvmName("jgjpkkyhjogtympk")
    public suspend fun aliases(vararg values: Output<KpiAliasArgs>) {
        this.aliases = Output.all(values.asList())
    }

    /**
     * @param values The aliases.
     */
    @JvmName("sttxxlffrceunuwl")
    public suspend fun aliases(values: List<Output<KpiAliasArgs>>) {
        this.aliases = Output.all(values)
    }

    /**
     * @param value The calculation window.
     */
    @JvmName("haktylffhuwwmpye")
    public suspend fun calculationWindow(`value`: Output<CalculationWindowTypes>) {
        this.calculationWindow = value
    }

    /**
     * @param value Name of calculation window field.
     */
    @JvmName("pycurbqxxdkjhdmr")
    public suspend fun calculationWindowFieldName(`value`: Output<String>) {
        this.calculationWindowFieldName = value
    }

    /**
     * @param value Localized description for the KPI.
     */
    @JvmName("nfahexbgsrrmutfr")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Localized display name for the KPI.
     */
    @JvmName("hmhnchjdbxtjfhxd")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The mapping entity type.
     */
    @JvmName("iaaaaisqahkhpvcq")
    public suspend fun entityType(`value`: Output<EntityTypes>) {
        this.entityType = value
    }

    /**
     * @param value The mapping entity name.
     */
    @JvmName("rcjndptbqqwfsqwh")
    public suspend fun entityTypeName(`value`: Output<String>) {
        this.entityTypeName = value
    }

    /**
     * @param value The computation expression for the KPI.
     */
    @JvmName("ynjtsxgdrxmqjora")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The KPI extracts.
     */
    @JvmName("pfsjrpycoapwfsvs")
    public suspend fun extracts(`value`: Output<List<KpiExtractArgs>>) {
        this.extracts = value
    }

    @JvmName("loesnlvlaqvkjrbu")
    public suspend fun extracts(vararg values: Output<KpiExtractArgs>) {
        this.extracts = Output.all(values.asList())
    }

    /**
     * @param values The KPI extracts.
     */
    @JvmName("ibbiqxptiuysrrnc")
    public suspend fun extracts(values: List<Output<KpiExtractArgs>>) {
        this.extracts = Output.all(values)
    }

    /**
     * @param value The filter expression for the KPI.
     */
    @JvmName("rmofjjcvgyxwsnet")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value The computation function for the KPI.
     */
    @JvmName("bjxykmdsbpqkwnja")
    public suspend fun function(`value`: Output<KpiFunctions>) {
        this.function = value
    }

    /**
     * @param value the group by properties for the KPI.
     */
    @JvmName("cdyaenmmcpppmjxp")
    public suspend fun groupBy(`value`: Output<List<String>>) {
        this.groupBy = value
    }

    @JvmName("yrjgubsscsrietar")
    public suspend fun groupBy(vararg values: Output<String>) {
        this.groupBy = Output.all(values.asList())
    }

    /**
     * @param values the group by properties for the KPI.
     */
    @JvmName("stcrxpxhuenxbnkt")
    public suspend fun groupBy(values: List<Output<String>>) {
        this.groupBy = Output.all(values)
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("xtqnadgglojshwor")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value The name of the KPI.
     */
    @JvmName("ddavumcqysjxjpmh")
    public suspend fun kpiName(`value`: Output<String>) {
        this.kpiName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("oovskhwiqgrwrkqr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The KPI thresholds.
     */
    @JvmName("mwhdygvyafflipuj")
    public suspend fun thresHolds(`value`: Output<KpiThresholdsArgs>) {
        this.thresHolds = value
    }

    /**
     * @param value The unit of measurement for the KPI.
     */
    @JvmName("ajqnelfrakkpixrq")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value The aliases.
     */
    @JvmName("sbxspsyniwdehiyt")
    public suspend fun aliases(`value`: List<KpiAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param argument The aliases.
     */
    @JvmName("kwhoymgmpxjkjowp")
    public suspend fun aliases(argument: List<suspend KpiAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { KpiAliasArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param argument The aliases.
     */
    @JvmName("sbxqibpslaoudtwi")
    public suspend fun aliases(vararg argument: suspend KpiAliasArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { KpiAliasArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param argument The aliases.
     */
    @JvmName("pkuyipvccwgfbmbq")
    public suspend fun aliases(argument: suspend KpiAliasArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KpiAliasArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.aliases = mapped
    }

    /**
     * @param values The aliases.
     */
    @JvmName("gojtsuemeaaywuru")
    public suspend fun aliases(vararg values: KpiAliasArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param value The calculation window.
     */
    @JvmName("jjwowemegqyxwxjg")
    public suspend fun calculationWindow(`value`: CalculationWindowTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.calculationWindow = mapped
    }

    /**
     * @param value Name of calculation window field.
     */
    @JvmName("manxlfyddgfjbicl")
    public suspend fun calculationWindowFieldName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.calculationWindowFieldName = mapped
    }

    /**
     * @param value Localized description for the KPI.
     */
    @JvmName("vxwmwgqetyjqamga")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Localized description for the KPI.
     */
    @JvmName("otqhudtmxxwgliqf")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Localized display name for the KPI.
     */
    @JvmName("mnqaqokclodaoxqk")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Localized display name for the KPI.
     */
    @JvmName("feeyihpbubvlnyfb")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The mapping entity type.
     */
    @JvmName("vbgsthgudommruvq")
    public suspend fun entityType(`value`: EntityTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityType = mapped
    }

    /**
     * @param value The mapping entity name.
     */
    @JvmName("bngdvfedymdicwqb")
    public suspend fun entityTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityTypeName = mapped
    }

    /**
     * @param value The computation expression for the KPI.
     */
    @JvmName("gfhrexwatxkqanek")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The KPI extracts.
     */
    @JvmName("pwcjbvuvgsrskkkj")
    public suspend fun extracts(`value`: List<KpiExtractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extracts = mapped
    }

    /**
     * @param argument The KPI extracts.
     */
    @JvmName("ovsuxdyukhhjmfai")
    public suspend fun extracts(argument: List<suspend KpiExtractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { KpiExtractArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extracts = mapped
    }

    /**
     * @param argument The KPI extracts.
     */
    @JvmName("pmdkdyirossrlhvl")
    public suspend fun extracts(vararg argument: suspend KpiExtractArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { KpiExtractArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.extracts = mapped
    }

    /**
     * @param argument The KPI extracts.
     */
    @JvmName("nqecmjvmqkvrdhfx")
    public suspend fun extracts(argument: suspend KpiExtractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KpiExtractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extracts = mapped
    }

    /**
     * @param values The KPI extracts.
     */
    @JvmName("pfdggqnkbwsjwbfs")
    public suspend fun extracts(vararg values: KpiExtractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extracts = mapped
    }

    /**
     * @param value The filter expression for the KPI.
     */
    @JvmName("jctqtfsebybuvqpw")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The computation function for the KPI.
     */
    @JvmName("sufxtqvrnppwwnah")
    public suspend fun function(`value`: KpiFunctions?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value the group by properties for the KPI.
     */
    @JvmName("ovmausqxhxutbgba")
    public suspend fun groupBy(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupBy = mapped
    }

    /**
     * @param values the group by properties for the KPI.
     */
    @JvmName("fdkkhagitdyxbdlw")
    public suspend fun groupBy(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupBy = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("joxatqoadhkydhux")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value The name of the KPI.
     */
    @JvmName("wctymknseefieahb")
    public suspend fun kpiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kpiName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("svfdtvnpiyhjoobv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The KPI thresholds.
     */
    @JvmName("uoublgyuqtxyppkx")
    public suspend fun thresHolds(`value`: KpiThresholdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thresHolds = mapped
    }

    /**
     * @param argument The KPI thresholds.
     */
    @JvmName("vywhhktjewhuadiw")
    public suspend fun thresHolds(argument: suspend KpiThresholdsArgsBuilder.() -> Unit) {
        val toBeMapped = KpiThresholdsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.thresHolds = mapped
    }

    /**
     * @param value The unit of measurement for the KPI.
     */
    @JvmName("scabnewtcfouuobd")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): KpiArgs = KpiArgs(
        aliases = aliases,
        calculationWindow = calculationWindow,
        calculationWindowFieldName = calculationWindowFieldName,
        description = description,
        displayName = displayName,
        entityType = entityType,
        entityTypeName = entityTypeName,
        expression = expression,
        extracts = extracts,
        filter = filter,
        function = function,
        groupBy = groupBy,
        hubName = hubName,
        kpiName = kpiName,
        resourceGroupName = resourceGroupName,
        thresHolds = thresHolds,
        unit = unit,
    )
}
