@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseGrades
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseMappings
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseSystemGeneratedEntities
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseGrades.Companion.toKotlin as predictionResponseGradesToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseMappings.Companion.toKotlin as predictionResponseMappingsToKotlin
import com.pulumi.azurenative.customerinsights.kotlin.outputs.PredictionResponseSystemGeneratedEntities.Companion.toKotlin as predictionResponseSystemGeneratedEntitiesToKotlin

/**
 * Builder for [Prediction].
 */
@PulumiTagMarker
public class PredictionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PredictionArgs = PredictionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PredictionArgsBuilder.() -> Unit) {
        val builder = PredictionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Prediction {
        val builtJavaResource =
            com.pulumi.azurenative.customerinsights.Prediction(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Prediction(builtJavaResource)
    }
}

/**
 * The prediction resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Predictions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prediction = new AzureNative.CustomerInsights.Prediction("prediction", new()
 *     {
 *         AutoAnalyze = true,
 *         Description =
 *         {
 *             { "en-us", "sdktest" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "sdktest" },
 *         },
 *         Grades = new[] {},
 *         HubName = "sdkTestHub",
 *         InvolvedInteractionTypes = new[] {},
 *         InvolvedKpiTypes = new[] {},
 *         InvolvedRelationships = new[] {},
 *         Mappings = new AzureNative.CustomerInsights.Inputs.PredictionMappingsArgs
 *         {
 *             Grade = "sdktest_Grade",
 *             Reason = "sdktest_Reason",
 *             Score = "sdktest_Score",
 *         },
 *         NegativeOutcomeExpression = "Customers.FirstName = 'Mike'",
 *         PositiveOutcomeExpression = "Customers.FirstName = 'David'",
 *         PredictionName = "sdktest",
 *         PrimaryProfileType = "Customers",
 *         ResourceGroupName = "TestHubRG",
 *         ScopeExpression = "*",
 *         ScoreLabel = "score label",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewPrediction(ctx, "prediction", &customerinsights.PredictionArgs{
 * 			AutoAnalyze: pulumi.Bool(true),
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("sdktest"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("sdktest"),
 * 			},
 * 			Grades:                   customerinsights.PredictionGradesArray{},
 * 			HubName:                  pulumi.String("sdkTestHub"),
 * 			InvolvedInteractionTypes: pulumi.StringArray{},
 * 			InvolvedKpiTypes:         pulumi.StringArray{},
 * 			InvolvedRelationships:    pulumi.StringArray{},
 * 			Mappings: &customerinsights.PredictionMappingsArgs{
 * 				Grade:  pulumi.String("sdktest_Grade"),
 * 				Reason: pulumi.String("sdktest_Reason"),
 * 				Score:  pulumi.String("sdktest_Score"),
 * 			},
 * 			NegativeOutcomeExpression: pulumi.String("Customers.FirstName = 'Mike'"),
 * 			PositiveOutcomeExpression: pulumi.String("Customers.FirstName = 'David'"),
 * 			PredictionName:            pulumi.String("sdktest"),
 * 			PrimaryProfileType:        pulumi.String("Customers"),
 * 			ResourceGroupName:         pulumi.String("TestHubRG"),
 * 			ScopeExpression:           pulumi.String("*"),
 * 			ScoreLabel:                pulumi.String("score label"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Prediction;
 * import com.pulumi.azurenative.customerinsights.PredictionArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.PredictionMappingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prediction = new Prediction("prediction", PredictionArgs.builder()
 *             .autoAnalyze(true)
 *             .description(Map.of("en-us", "sdktest"))
 *             .displayName(Map.of("en-us", "sdktest"))
 *             .grades()
 *             .hubName("sdkTestHub")
 *             .involvedInteractionTypes()
 *             .involvedKpiTypes()
 *             .involvedRelationships()
 *             .mappings(PredictionMappingsArgs.builder()
 *                 .grade("sdktest_Grade")
 *                 .reason("sdktest_Reason")
 *                 .score("sdktest_Score")
 *                 .build())
 *             .negativeOutcomeExpression("Customers.FirstName = 'Mike'")
 *             .positiveOutcomeExpression("Customers.FirstName = 'David'")
 *             .predictionName("sdktest")
 *             .primaryProfileType("Customers")
 *             .resourceGroupName("TestHubRG")
 *             .scopeExpression("*")
 *             .scoreLabel("score label")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Prediction sdkTestHub/sdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}
 * ```
 */
public class Prediction internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.Prediction,
) : KotlinCustomResource(javaResource, PredictionMapper) {
    /**
     * Whether do auto analyze.
     */
    public val autoAnalyze: Output<Boolean>
        get() = javaResource.autoAnalyze().applyValue({ args0 -> args0 })

    /**
     * Description of the prediction.
     */
    public val description: Output<Map<String, String>>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Display name of the prediction.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The prediction grades.
     */
    public val grades: Output<List<PredictionResponseGrades>>?
        get() = javaResource.grades().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> predictionResponseGradesToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Interaction types involved in the prediction.
     */
    public val involvedInteractionTypes: Output<List<String>>?
        get() = javaResource.involvedInteractionTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * KPI types involved in the prediction.
     */
    public val involvedKpiTypes: Output<List<String>>?
        get() = javaResource.involvedKpiTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Relationships involved in the prediction.
     */
    public val involvedRelationships: Output<List<String>>?
        get() = javaResource.involvedRelationships().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Definition of the link mapping of prediction.
     */
    public val mappings: Output<PredictionResponseMappings>
        get() = javaResource.mappings().applyValue({ args0 ->
            args0.let({ args0 ->
                predictionResponseMappingsToKotlin(args0)
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Negative outcome expression.
     */
    public val negativeOutcomeExpression: Output<String>
        get() = javaResource.negativeOutcomeExpression().applyValue({ args0 -> args0 })

    /**
     * Positive outcome expression.
     */
    public val positiveOutcomeExpression: Output<String>
        get() = javaResource.positiveOutcomeExpression().applyValue({ args0 -> args0 })

    /**
     * Name of the prediction.
     */
    public val predictionName: Output<String>?
        get() = javaResource.predictionName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Primary profile type.
     */
    public val primaryProfileType: Output<String>
        get() = javaResource.primaryProfileType().applyValue({ args0 -> args0 })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Scope expression.
     */
    public val scopeExpression: Output<String>
        get() = javaResource.scopeExpression().applyValue({ args0 -> args0 })

    /**
     * Score label.
     */
    public val scoreLabel: Output<String>
        get() = javaResource.scoreLabel().applyValue({ args0 -> args0 })

    /**
     * System generated entities.
     */
    public val systemGeneratedEntities: Output<PredictionResponseSystemGeneratedEntities>
        get() = javaResource.systemGeneratedEntities().applyValue({ args0 ->
            args0.let({ args0 ->
                predictionResponseSystemGeneratedEntitiesToKotlin(args0)
            })
        })

    /**
     * The hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PredictionMapper : ResourceMapper<Prediction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.Prediction::class == javaResource::class

    override fun map(javaResource: Resource): Prediction = Prediction(
        javaResource as
            com.pulumi.azurenative.customerinsights.Prediction,
    )
}

/**
 * @see [Prediction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Prediction].
 */
public suspend fun prediction(name: String, block: suspend PredictionResourceBuilder.() -> Unit):
    Prediction {
    val builder = PredictionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Prediction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prediction(name: String): Prediction {
    val builder = PredictionResourceBuilder()
    builder.name(name)
    return builder.build()
}
