@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.azurenative.customerinsights.PredictionArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PredictionGradesArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PredictionGradesArgsBuilder
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PredictionMappingsArgs
import com.pulumi.azurenative.customerinsights.kotlin.inputs.PredictionMappingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The prediction resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Predictions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prediction = new AzureNative.CustomerInsights.Prediction("prediction", new()
 *     {
 *         AutoAnalyze = true,
 *         Description =
 *         {
 *             { "en-us", "sdktest" },
 *         },
 *         DisplayName =
 *         {
 *             { "en-us", "sdktest" },
 *         },
 *         Grades = new[] {},
 *         HubName = "sdkTestHub",
 *         InvolvedInteractionTypes = new[] {},
 *         InvolvedKpiTypes = new[] {},
 *         InvolvedRelationships = new[] {},
 *         Mappings = new AzureNative.CustomerInsights.Inputs.PredictionMappingsArgs
 *         {
 *             Grade = "sdktest_Grade",
 *             Reason = "sdktest_Reason",
 *             Score = "sdktest_Score",
 *         },
 *         NegativeOutcomeExpression = "Customers.FirstName = 'Mike'",
 *         PositiveOutcomeExpression = "Customers.FirstName = 'David'",
 *         PredictionName = "sdktest",
 *         PrimaryProfileType = "Customers",
 *         ResourceGroupName = "TestHubRG",
 *         ScopeExpression = "*",
 *         ScoreLabel = "score label",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewPrediction(ctx, "prediction", &customerinsights.PredictionArgs{
 * 			AutoAnalyze: pulumi.Bool(true),
 * 			Description: pulumi.StringMap{
 * 				"en-us": pulumi.String("sdktest"),
 * 			},
 * 			DisplayName: pulumi.StringMap{
 * 				"en-us": pulumi.String("sdktest"),
 * 			},
 * 			Grades:                   customerinsights.PredictionGradesArray{},
 * 			HubName:                  pulumi.String("sdkTestHub"),
 * 			InvolvedInteractionTypes: pulumi.StringArray{},
 * 			InvolvedKpiTypes:         pulumi.StringArray{},
 * 			InvolvedRelationships:    pulumi.StringArray{},
 * 			Mappings: &customerinsights.PredictionMappingsArgs{
 * 				Grade:  pulumi.String("sdktest_Grade"),
 * 				Reason: pulumi.String("sdktest_Reason"),
 * 				Score:  pulumi.String("sdktest_Score"),
 * 			},
 * 			NegativeOutcomeExpression: pulumi.String("Customers.FirstName = 'Mike'"),
 * 			PositiveOutcomeExpression: pulumi.String("Customers.FirstName = 'David'"),
 * 			PredictionName:            pulumi.String("sdktest"),
 * 			PrimaryProfileType:        pulumi.String("Customers"),
 * 			ResourceGroupName:         pulumi.String("TestHubRG"),
 * 			ScopeExpression:           pulumi.String("*"),
 * 			ScoreLabel:                pulumi.String("score label"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.Prediction;
 * import com.pulumi.azurenative.customerinsights.PredictionArgs;
 * import com.pulumi.azurenative.customerinsights.inputs.PredictionMappingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prediction = new Prediction("prediction", PredictionArgs.builder()
 *             .autoAnalyze(true)
 *             .description(Map.of("en-us", "sdktest"))
 *             .displayName(Map.of("en-us", "sdktest"))
 *             .grades()
 *             .hubName("sdkTestHub")
 *             .involvedInteractionTypes()
 *             .involvedKpiTypes()
 *             .involvedRelationships()
 *             .mappings(PredictionMappingsArgs.builder()
 *                 .grade("sdktest_Grade")
 *                 .reason("sdktest_Reason")
 *                 .score("sdktest_Score")
 *                 .build())
 *             .negativeOutcomeExpression("Customers.FirstName = 'Mike'")
 *             .positiveOutcomeExpression("Customers.FirstName = 'David'")
 *             .predictionName("sdktest")
 *             .primaryProfileType("Customers")
 *             .resourceGroupName("TestHubRG")
 *             .scopeExpression("*")
 *             .scoreLabel("score label")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:Prediction sdkTestHub/sdktest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/predictions/{predictionName}
 * ```
 * @property autoAnalyze Whether do auto analyze.
 * @property description Description of the prediction.
 * @property displayName Display name of the prediction.
 * @property grades The prediction grades.
 * @property hubName The name of the hub.
 * @property involvedInteractionTypes Interaction types involved in the prediction.
 * @property involvedKpiTypes KPI types involved in the prediction.
 * @property involvedRelationships Relationships involved in the prediction.
 * @property mappings Definition of the link mapping of prediction.
 * @property negativeOutcomeExpression Negative outcome expression.
 * @property positiveOutcomeExpression Positive outcome expression.
 * @property predictionName Name of the prediction.
 * @property primaryProfileType Primary profile type.
 * @property resourceGroupName The name of the resource group.
 * @property scopeExpression Scope expression.
 * @property scoreLabel Score label.
 */
public data class PredictionArgs(
    public val autoAnalyze: Output<Boolean>? = null,
    public val description: Output<Map<String, String>>? = null,
    public val displayName: Output<Map<String, String>>? = null,
    public val grades: Output<List<PredictionGradesArgs>>? = null,
    public val hubName: Output<String>? = null,
    public val involvedInteractionTypes: Output<List<String>>? = null,
    public val involvedKpiTypes: Output<List<String>>? = null,
    public val involvedRelationships: Output<List<String>>? = null,
    public val mappings: Output<PredictionMappingsArgs>? = null,
    public val negativeOutcomeExpression: Output<String>? = null,
    public val positiveOutcomeExpression: Output<String>? = null,
    public val predictionName: Output<String>? = null,
    public val primaryProfileType: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeExpression: Output<String>? = null,
    public val scoreLabel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.PredictionArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.PredictionArgs =
        com.pulumi.azurenative.customerinsights.PredictionArgs.builder()
            .autoAnalyze(autoAnalyze?.applyValue({ args0 -> args0 }))
            .description(
                description?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .displayName(
                displayName?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .grades(grades?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .hubName(hubName?.applyValue({ args0 -> args0 }))
            .involvedInteractionTypes(
                involvedInteractionTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .involvedKpiTypes(involvedKpiTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .involvedRelationships(involvedRelationships?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mappings(mappings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .negativeOutcomeExpression(negativeOutcomeExpression?.applyValue({ args0 -> args0 }))
            .positiveOutcomeExpression(positiveOutcomeExpression?.applyValue({ args0 -> args0 }))
            .predictionName(predictionName?.applyValue({ args0 -> args0 }))
            .primaryProfileType(primaryProfileType?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeExpression(scopeExpression?.applyValue({ args0 -> args0 }))
            .scoreLabel(scoreLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PredictionArgs].
 */
@PulumiTagMarker
public class PredictionArgsBuilder internal constructor() {
    private var autoAnalyze: Output<Boolean>? = null

    private var description: Output<Map<String, String>>? = null

    private var displayName: Output<Map<String, String>>? = null

    private var grades: Output<List<PredictionGradesArgs>>? = null

    private var hubName: Output<String>? = null

    private var involvedInteractionTypes: Output<List<String>>? = null

    private var involvedKpiTypes: Output<List<String>>? = null

    private var involvedRelationships: Output<List<String>>? = null

    private var mappings: Output<PredictionMappingsArgs>? = null

    private var negativeOutcomeExpression: Output<String>? = null

    private var positiveOutcomeExpression: Output<String>? = null

    private var predictionName: Output<String>? = null

    private var primaryProfileType: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeExpression: Output<String>? = null

    private var scoreLabel: Output<String>? = null

    /**
     * @param value Whether do auto analyze.
     */
    @JvmName("odvbhchpuegnblww")
    public suspend fun autoAnalyze(`value`: Output<Boolean>) {
        this.autoAnalyze = value
    }

    /**
     * @param value Description of the prediction.
     */
    @JvmName("xrwyprmfqbfgovbs")
    public suspend fun description(`value`: Output<Map<String, String>>) {
        this.description = value
    }

    /**
     * @param value Display name of the prediction.
     */
    @JvmName("nmhkcmcwouiaiqcm")
    public suspend fun displayName(`value`: Output<Map<String, String>>) {
        this.displayName = value
    }

    /**
     * @param value The prediction grades.
     */
    @JvmName("shfcqrvtxsykicxc")
    public suspend fun grades(`value`: Output<List<PredictionGradesArgs>>) {
        this.grades = value
    }

    @JvmName("ychtclqkbjhlxsdx")
    public suspend fun grades(vararg values: Output<PredictionGradesArgs>) {
        this.grades = Output.all(values.asList())
    }

    /**
     * @param values The prediction grades.
     */
    @JvmName("tjuioyjdbgvunqix")
    public suspend fun grades(values: List<Output<PredictionGradesArgs>>) {
        this.grades = Output.all(values)
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("pencnhbhtinmoqic")
    public suspend fun hubName(`value`: Output<String>) {
        this.hubName = value
    }

    /**
     * @param value Interaction types involved in the prediction.
     */
    @JvmName("jcxxvcryjvrsblvd")
    public suspend fun involvedInteractionTypes(`value`: Output<List<String>>) {
        this.involvedInteractionTypes = value
    }

    @JvmName("udgqsivuyxdbfusx")
    public suspend fun involvedInteractionTypes(vararg values: Output<String>) {
        this.involvedInteractionTypes = Output.all(values.asList())
    }

    /**
     * @param values Interaction types involved in the prediction.
     */
    @JvmName("lbwthwaphvvikuqw")
    public suspend fun involvedInteractionTypes(values: List<Output<String>>) {
        this.involvedInteractionTypes = Output.all(values)
    }

    /**
     * @param value KPI types involved in the prediction.
     */
    @JvmName("bvntasbbrcgdlxxn")
    public suspend fun involvedKpiTypes(`value`: Output<List<String>>) {
        this.involvedKpiTypes = value
    }

    @JvmName("mnmwdonbfshotwst")
    public suspend fun involvedKpiTypes(vararg values: Output<String>) {
        this.involvedKpiTypes = Output.all(values.asList())
    }

    /**
     * @param values KPI types involved in the prediction.
     */
    @JvmName("ojtvsqwmfhnmumai")
    public suspend fun involvedKpiTypes(values: List<Output<String>>) {
        this.involvedKpiTypes = Output.all(values)
    }

    /**
     * @param value Relationships involved in the prediction.
     */
    @JvmName("omqnnewvqghmevjn")
    public suspend fun involvedRelationships(`value`: Output<List<String>>) {
        this.involvedRelationships = value
    }

    @JvmName("motryyettsgmdtqo")
    public suspend fun involvedRelationships(vararg values: Output<String>) {
        this.involvedRelationships = Output.all(values.asList())
    }

    /**
     * @param values Relationships involved in the prediction.
     */
    @JvmName("cmxgvvoqmwnrbcdy")
    public suspend fun involvedRelationships(values: List<Output<String>>) {
        this.involvedRelationships = Output.all(values)
    }

    /**
     * @param value Definition of the link mapping of prediction.
     */
    @JvmName("tclscnagfijqcahj")
    public suspend fun mappings(`value`: Output<PredictionMappingsArgs>) {
        this.mappings = value
    }

    /**
     * @param value Negative outcome expression.
     */
    @JvmName("vhnqcsywpjgjmpud")
    public suspend fun negativeOutcomeExpression(`value`: Output<String>) {
        this.negativeOutcomeExpression = value
    }

    /**
     * @param value Positive outcome expression.
     */
    @JvmName("vkdqlyxwhbbeoqed")
    public suspend fun positiveOutcomeExpression(`value`: Output<String>) {
        this.positiveOutcomeExpression = value
    }

    /**
     * @param value Name of the prediction.
     */
    @JvmName("duyjclvuinghuapb")
    public suspend fun predictionName(`value`: Output<String>) {
        this.predictionName = value
    }

    /**
     * @param value Primary profile type.
     */
    @JvmName("ivsveorsjxutstbp")
    public suspend fun primaryProfileType(`value`: Output<String>) {
        this.primaryProfileType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qfrculmpxnfovdjd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Scope expression.
     */
    @JvmName("uyyechpystieckju")
    public suspend fun scopeExpression(`value`: Output<String>) {
        this.scopeExpression = value
    }

    /**
     * @param value Score label.
     */
    @JvmName("lsiijpjuuhdrpscr")
    public suspend fun scoreLabel(`value`: Output<String>) {
        this.scoreLabel = value
    }

    /**
     * @param value Whether do auto analyze.
     */
    @JvmName("vyqjbopkepivkhrm")
    public suspend fun autoAnalyze(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAnalyze = mapped
    }

    /**
     * @param value Description of the prediction.
     */
    @JvmName("gvuebxjnoaqfenpn")
    public suspend fun description(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param values Description of the prediction.
     */
    @JvmName("qeuvejebqriupgjc")
    public fun description(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of the prediction.
     */
    @JvmName("bqwmbugwhhxntkxx")
    public suspend fun displayName(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param values Display name of the prediction.
     */
    @JvmName("auolxxkijvnmhbht")
    public fun displayName(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The prediction grades.
     */
    @JvmName("fxdsxqqpiobmtluk")
    public suspend fun grades(`value`: List<PredictionGradesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grades = mapped
    }

    /**
     * @param argument The prediction grades.
     */
    @JvmName("xugtttkaprylhcem")
    public suspend fun grades(argument: List<suspend PredictionGradesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PredictionGradesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.grades = mapped
    }

    /**
     * @param argument The prediction grades.
     */
    @JvmName("lipkcyneexcpcbug")
    public suspend fun grades(vararg argument: suspend PredictionGradesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PredictionGradesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.grades = mapped
    }

    /**
     * @param argument The prediction grades.
     */
    @JvmName("uuasnlqpbhshkhtg")
    public suspend fun grades(argument: suspend PredictionGradesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PredictionGradesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.grades = mapped
    }

    /**
     * @param values The prediction grades.
     */
    @JvmName("tsttuairfjrhrdcu")
    public suspend fun grades(vararg values: PredictionGradesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.grades = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("tiwhelpcsbslhfmw")
    public suspend fun hubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubName = mapped
    }

    /**
     * @param value Interaction types involved in the prediction.
     */
    @JvmName("xecvbvlrpxvuugrr")
    public suspend fun involvedInteractionTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.involvedInteractionTypes = mapped
    }

    /**
     * @param values Interaction types involved in the prediction.
     */
    @JvmName("klefechwqefamgsw")
    public suspend fun involvedInteractionTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.involvedInteractionTypes = mapped
    }

    /**
     * @param value KPI types involved in the prediction.
     */
    @JvmName("nkqjfgvonlflvnmk")
    public suspend fun involvedKpiTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.involvedKpiTypes = mapped
    }

    /**
     * @param values KPI types involved in the prediction.
     */
    @JvmName("citrwsiytdmuljxa")
    public suspend fun involvedKpiTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.involvedKpiTypes = mapped
    }

    /**
     * @param value Relationships involved in the prediction.
     */
    @JvmName("tujkxiyuajdlqorv")
    public suspend fun involvedRelationships(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.involvedRelationships = mapped
    }

    /**
     * @param values Relationships involved in the prediction.
     */
    @JvmName("kxmexjcsbcykkrwb")
    public suspend fun involvedRelationships(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.involvedRelationships = mapped
    }

    /**
     * @param value Definition of the link mapping of prediction.
     */
    @JvmName("qnpxyqnwcwbineea")
    public suspend fun mappings(`value`: PredictionMappingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappings = mapped
    }

    /**
     * @param argument Definition of the link mapping of prediction.
     */
    @JvmName("vusdurgeqvstshcp")
    public suspend fun mappings(argument: suspend PredictionMappingsArgsBuilder.() -> Unit) {
        val toBeMapped = PredictionMappingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mappings = mapped
    }

    /**
     * @param value Negative outcome expression.
     */
    @JvmName("nfmccnfgvbgbkbcl")
    public suspend fun negativeOutcomeExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negativeOutcomeExpression = mapped
    }

    /**
     * @param value Positive outcome expression.
     */
    @JvmName("iqnhorrauncuqlov")
    public suspend fun positiveOutcomeExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.positiveOutcomeExpression = mapped
    }

    /**
     * @param value Name of the prediction.
     */
    @JvmName("vdufqhlxeahepwxm")
    public suspend fun predictionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predictionName = mapped
    }

    /**
     * @param value Primary profile type.
     */
    @JvmName("acymhfavykvffusf")
    public suspend fun primaryProfileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryProfileType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bkdinpwvtuerrcwj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Scope expression.
     */
    @JvmName("dqidlrpfaycxwson")
    public suspend fun scopeExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeExpression = mapped
    }

    /**
     * @param value Score label.
     */
    @JvmName("dxpwyarbdfwavnpo")
    public suspend fun scoreLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scoreLabel = mapped
    }

    internal fun build(): PredictionArgs = PredictionArgs(
        autoAnalyze = autoAnalyze,
        description = description,
        displayName = displayName,
        grades = grades,
        hubName = hubName,
        involvedInteractionTypes = involvedInteractionTypes,
        involvedKpiTypes = involvedKpiTypes,
        involvedRelationships = involvedRelationships,
        mappings = mappings,
        negativeOutcomeExpression = negativeOutcomeExpression,
        positiveOutcomeExpression = positiveOutcomeExpression,
        predictionName = predictionName,
        primaryProfileType = primaryProfileType,
        resourceGroupName = resourceGroupName,
        scopeExpression = scopeExpression,
        scoreLabel = scoreLabel,
    )
}
