@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [View].
 */
@PulumiTagMarker
public class ViewResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ViewArgs = ViewArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ViewArgsBuilder.() -> Unit) {
        val builder = ViewArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): View {
        val builtJavaResource = com.pulumi.azurenative.customerinsights.View(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return View(builtJavaResource)
    }
}

/**
 * The view resource format.
 * Azure REST API version: 2017-04-26. Prior API version in Azure Native 1.x: 2017-04-26.
 * ## Example Usage
 * ### Views_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var view = new AzureNative.CustomerInsights.View("view", new()
 *     {
 *         Definition = "{\\\"isProfileType\\\":false,\\\"profileTypes\\\":[],\\\"widgets\\\":[],\\\"style\\\":[]}",
 *         DisplayName =
 *         {
 *             { "en", "some name" },
 *         },
 *         HubName = "sdkTestHub",
 *         ResourceGroupName = "TestHubRG",
 *         UserId = "testUser",
 *         ViewName = "testView",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customerinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customerinsights.NewView(ctx, "view", &customerinsights.ViewArgs{
 * 			Definition: pulumi.String("{\\\"isProfileType\\\":false,\\\"profileTypes\\\":[],\\\"widgets\\\":[],\\\"style\\\":[]}"),
 * 			DisplayName: pulumi.StringMap{
 * 				"en": pulumi.String("some name"),
 * 			},
 * 			HubName:           pulumi.String("sdkTestHub"),
 * 			ResourceGroupName: pulumi.String("TestHubRG"),
 * 			UserId:            pulumi.String("testUser"),
 * 			ViewName:          pulumi.String("testView"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customerinsights.View;
 * import com.pulumi.azurenative.customerinsights.ViewArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var view = new View("view", ViewArgs.builder()
 *             .definition("{\\\"isProfileType\\\":false,\\\"profileTypes\\\":[],\\\"widgets\\\":[],\\\"style\\\":[]}")
 *             .displayName(Map.of("en", "some name"))
 *             .hubName("sdkTestHub")
 *             .resourceGroupName("TestHubRG")
 *             .userId("testUser")
 *             .viewName("testView")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customerinsights:View sdkTestHub/testView /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/views/{viewName}
 * ```
 */
public class View internal constructor(
    override val javaResource: com.pulumi.azurenative.customerinsights.View,
) : KotlinCustomResource(javaResource, ViewMapper) {
    /**
     * Date time when view was last modified.
     */
    public val changed: Output<String>
        get() = javaResource.changed().applyValue({ args0 -> args0 })

    /**
     * Date time when view was created.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * View definition.
     */
    public val definition: Output<String>
        get() = javaResource.definition().applyValue({ args0 -> args0 })

    /**
     * Localized display name for the view.
     */
    public val displayName: Output<Map<String, String>>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * the hub name.
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * the user ID.
     */
    public val userId: Output<String>?
        get() = javaResource.userId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the view.
     */
    public val viewName: Output<String>
        get() = javaResource.viewName().applyValue({ args0 -> args0 })
}

public object ViewMapper : ResourceMapper<View> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customerinsights.View::class == javaResource::class

    override fun map(javaResource: Resource): View = View(
        javaResource as
            com.pulumi.azurenative.customerinsights.View,
    )
}

/**
 * @see [View].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [View].
 */
public suspend fun view(name: String, block: suspend ViewResourceBuilder.() -> Unit): View {
    val builder = ViewResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [View].
 * @param name The _unique_ name of the resulting resource.
 */
public fun view(name: String): View {
    val builder = ViewResourceBuilder()
    builder.name(name)
    return builder.build()
}
