@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingErrorManagementArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.ErrorManagementTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The error management.
 * @property errorLimit The error limit allowed while importing data.
 * @property errorManagementType The type of error management to use for the mapping.
 */
public data class ConnectorMappingErrorManagementArgs(
    public val errorLimit: Output<Int>? = null,
    public val errorManagementType: Output<ErrorManagementTypes>,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingErrorManagementArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingErrorManagementArgs =
        com.pulumi.azurenative.customerinsights.inputs.ConnectorMappingErrorManagementArgs.builder()
            .errorLimit(errorLimit?.applyValue({ args0 -> args0 }))
            .errorManagementType(
                errorManagementType.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorMappingErrorManagementArgs].
 */
@PulumiTagMarker
public class ConnectorMappingErrorManagementArgsBuilder internal constructor() {
    private var errorLimit: Output<Int>? = null

    private var errorManagementType: Output<ErrorManagementTypes>? = null

    /**
     * @param value The error limit allowed while importing data.
     */
    @JvmName("dsjanmvrjqovmyst")
    public suspend fun errorLimit(`value`: Output<Int>) {
        this.errorLimit = value
    }

    /**
     * @param value The type of error management to use for the mapping.
     */
    @JvmName("egiwgrqgcdaqsrnw")
    public suspend fun errorManagementType(`value`: Output<ErrorManagementTypes>) {
        this.errorManagementType = value
    }

    /**
     * @param value The error limit allowed while importing data.
     */
    @JvmName("rgfijvikiaifaues")
    public suspend fun errorLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorLimit = mapped
    }

    /**
     * @param value The type of error management to use for the mapping.
     */
    @JvmName("fymglhwojbcyaifc")
    public suspend fun errorManagementType(`value`: ErrorManagementTypes) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorManagementType = mapped
    }

    internal fun build(): ConnectorMappingErrorManagementArgs = ConnectorMappingErrorManagementArgs(
        errorLimit = errorLimit,
        errorManagementType = errorManagementType ?: throw PulumiNullFieldException("errorManagementType"),
    )
}
