@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.GetRoleAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assignmentName The name of the role assignment.
 * @property hubName The name of the hub.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetRoleAssignmentPlainArgs(
    public val assignmentName: String,
    public val hubName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.GetRoleAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.GetRoleAssignmentPlainArgs =
        com.pulumi.azurenative.customerinsights.inputs.GetRoleAssignmentPlainArgs.builder()
            .assignmentName(assignmentName.let({ args0 -> args0 }))
            .hubName(hubName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoleAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetRoleAssignmentPlainArgsBuilder internal constructor() {
    private var assignmentName: String? = null

    private var hubName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the role assignment.
     */
    @JvmName("itirhtahjvbhlkep")
    public suspend fun assignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assignmentName = mapped
    }

    /**
     * @param value The name of the hub.
     */
    @JvmName("rwipwmaeviketxox")
    public suspend fun hubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hubName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("telsynrkcplupmgh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRoleAssignmentPlainArgs = GetRoleAssignmentPlainArgs(
        assignmentName = assignmentName ?: throw PulumiNullFieldException("assignmentName"),
        hubName = hubName ?: throw PulumiNullFieldException("hubName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
