@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.KpiThresholdsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the KPI Threshold limits.
 * @property increasingKpi Whether or not the KPI is an increasing KPI.
 * @property lowerLimit The lower threshold limit.
 * @property upperLimit The upper threshold limit.
 */
public data class KpiThresholdsArgs(
    public val increasingKpi: Output<Boolean>,
    public val lowerLimit: Output<Double>,
    public val upperLimit: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.KpiThresholdsArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.KpiThresholdsArgs =
        com.pulumi.azurenative.customerinsights.inputs.KpiThresholdsArgs.builder()
            .increasingKpi(increasingKpi.applyValue({ args0 -> args0 }))
            .lowerLimit(lowerLimit.applyValue({ args0 -> args0 }))
            .upperLimit(upperLimit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KpiThresholdsArgs].
 */
@PulumiTagMarker
public class KpiThresholdsArgsBuilder internal constructor() {
    private var increasingKpi: Output<Boolean>? = null

    private var lowerLimit: Output<Double>? = null

    private var upperLimit: Output<Double>? = null

    /**
     * @param value Whether or not the KPI is an increasing KPI.
     */
    @JvmName("qlgdiyqddlngrvxu")
    public suspend fun increasingKpi(`value`: Output<Boolean>) {
        this.increasingKpi = value
    }

    /**
     * @param value The lower threshold limit.
     */
    @JvmName("hejjeneyexbqpype")
    public suspend fun lowerLimit(`value`: Output<Double>) {
        this.lowerLimit = value
    }

    /**
     * @param value The upper threshold limit.
     */
    @JvmName("krwdgqhbmpqhrfmm")
    public suspend fun upperLimit(`value`: Output<Double>) {
        this.upperLimit = value
    }

    /**
     * @param value Whether or not the KPI is an increasing KPI.
     */
    @JvmName("exhenalfllsscpcl")
    public suspend fun increasingKpi(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.increasingKpi = mapped
    }

    /**
     * @param value The lower threshold limit.
     */
    @JvmName("clcpeoyyfkaxgdfd")
    public suspend fun lowerLimit(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lowerLimit = mapped
    }

    /**
     * @param value The upper threshold limit.
     */
    @JvmName("bsebpcpkruprvrui")
    public suspend fun upperLimit(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upperLimit = mapped
    }

    internal fun build(): KpiThresholdsArgs = KpiThresholdsArgs(
        increasingKpi = increasingKpi ?: throw PulumiNullFieldException("increasingKpi"),
        lowerLimit = lowerLimit ?: throw PulumiNullFieldException("lowerLimit"),
        upperLimit = upperLimit ?: throw PulumiNullFieldException("upperLimit"),
    )
}
