@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.PredictionGradesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The definition of a prediction grade.
 * @property gradeName Name of the grade.
 * @property maxScoreThreshold Maximum score threshold.
 * @property minScoreThreshold Minimum score threshold.
 */
public data class PredictionGradesArgs(
    public val gradeName: Output<String>? = null,
    public val maxScoreThreshold: Output<Int>? = null,
    public val minScoreThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.PredictionGradesArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.PredictionGradesArgs =
        com.pulumi.azurenative.customerinsights.inputs.PredictionGradesArgs.builder()
            .gradeName(gradeName?.applyValue({ args0 -> args0 }))
            .maxScoreThreshold(maxScoreThreshold?.applyValue({ args0 -> args0 }))
            .minScoreThreshold(minScoreThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PredictionGradesArgs].
 */
@PulumiTagMarker
public class PredictionGradesArgsBuilder internal constructor() {
    private var gradeName: Output<String>? = null

    private var maxScoreThreshold: Output<Int>? = null

    private var minScoreThreshold: Output<Int>? = null

    /**
     * @param value Name of the grade.
     */
    @JvmName("cgtusflscvvjaqsh")
    public suspend fun gradeName(`value`: Output<String>) {
        this.gradeName = value
    }

    /**
     * @param value Maximum score threshold.
     */
    @JvmName("prvcmyddqxrxdxkf")
    public suspend fun maxScoreThreshold(`value`: Output<Int>) {
        this.maxScoreThreshold = value
    }

    /**
     * @param value Minimum score threshold.
     */
    @JvmName("tkyxvxdfcbpxcamu")
    public suspend fun minScoreThreshold(`value`: Output<Int>) {
        this.minScoreThreshold = value
    }

    /**
     * @param value Name of the grade.
     */
    @JvmName("frxyjxymdyhhbfnh")
    public suspend fun gradeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gradeName = mapped
    }

    /**
     * @param value Maximum score threshold.
     */
    @JvmName("ucbvifkrttpuxlcl")
    public suspend fun maxScoreThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxScoreThreshold = mapped
    }

    /**
     * @param value Minimum score threshold.
     */
    @JvmName("fsxqxttscupbhugw")
    public suspend fun minScoreThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minScoreThreshold = mapped
    }

    internal fun build(): PredictionGradesArgs = PredictionGradesArgs(
        gradeName = gradeName,
        maxScoreThreshold = maxScoreThreshold,
        minScoreThreshold = minScoreThreshold,
    )
}
