@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.PropertyDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Property definition.
 * @property arrayValueSeparator Array value separator for properties with isArray set.
 * @property enumValidValues Describes valid values for an enum property.
 * @property fieldName Name of the property.
 * @property fieldType Type of the property.
 * @property isArray Indicates if the property is actually an array of the fieldType above on the data api.
 * @property isAvailableInGraph Whether property is available in graph or not.
 * @property isEnum Indicates if the property is an enum.
 * @property isFlagEnum Indicates if the property is an flag enum.
 * @property isImage Whether the property is an Image.
 * @property isLocalizedString Whether the property is a localized string.
 * @property isName Whether the property is a name or a part of name.
 * @property isRequired Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
 * @property maxLength Max length of string. Used only if type is string.
 * @property propertyId The ID associated with the property.
 * @property schemaItemPropLink URL encoded schema.org item prop link for the property.
 */
public data class PropertyDefinitionArgs(
    public val arrayValueSeparator: Output<String>? = null,
    public val enumValidValues: Output<List<ProfileEnumValidValuesFormatArgs>>? = null,
    public val fieldName: Output<String>,
    public val fieldType: Output<String>,
    public val isArray: Output<Boolean>? = null,
    public val isAvailableInGraph: Output<Boolean>? = null,
    public val isEnum: Output<Boolean>? = null,
    public val isFlagEnum: Output<Boolean>? = null,
    public val isImage: Output<Boolean>? = null,
    public val isLocalizedString: Output<Boolean>? = null,
    public val isName: Output<Boolean>? = null,
    public val isRequired: Output<Boolean>? = null,
    public val maxLength: Output<Int>? = null,
    public val propertyId: Output<String>? = null,
    public val schemaItemPropLink: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.PropertyDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.customerinsights.inputs.PropertyDefinitionArgs =
        com.pulumi.azurenative.customerinsights.inputs.PropertyDefinitionArgs.builder()
            .arrayValueSeparator(arrayValueSeparator?.applyValue({ args0 -> args0 }))
            .enumValidValues(
                enumValidValues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fieldName(fieldName.applyValue({ args0 -> args0 }))
            .fieldType(fieldType.applyValue({ args0 -> args0 }))
            .isArray(isArray?.applyValue({ args0 -> args0 }))
            .isAvailableInGraph(isAvailableInGraph?.applyValue({ args0 -> args0 }))
            .isEnum(isEnum?.applyValue({ args0 -> args0 }))
            .isFlagEnum(isFlagEnum?.applyValue({ args0 -> args0 }))
            .isImage(isImage?.applyValue({ args0 -> args0 }))
            .isLocalizedString(isLocalizedString?.applyValue({ args0 -> args0 }))
            .isName(isName?.applyValue({ args0 -> args0 }))
            .isRequired(isRequired?.applyValue({ args0 -> args0 }))
            .maxLength(maxLength?.applyValue({ args0 -> args0 }))
            .propertyId(propertyId?.applyValue({ args0 -> args0 }))
            .schemaItemPropLink(schemaItemPropLink?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PropertyDefinitionArgs].
 */
@PulumiTagMarker
public class PropertyDefinitionArgsBuilder internal constructor() {
    private var arrayValueSeparator: Output<String>? = null

    private var enumValidValues: Output<List<ProfileEnumValidValuesFormatArgs>>? = null

    private var fieldName: Output<String>? = null

    private var fieldType: Output<String>? = null

    private var isArray: Output<Boolean>? = null

    private var isAvailableInGraph: Output<Boolean>? = null

    private var isEnum: Output<Boolean>? = null

    private var isFlagEnum: Output<Boolean>? = null

    private var isImage: Output<Boolean>? = null

    private var isLocalizedString: Output<Boolean>? = null

    private var isName: Output<Boolean>? = null

    private var isRequired: Output<Boolean>? = null

    private var maxLength: Output<Int>? = null

    private var propertyId: Output<String>? = null

    private var schemaItemPropLink: Output<String>? = null

    /**
     * @param value Array value separator for properties with isArray set.
     */
    @JvmName("ykwtwyavifgprbrp")
    public suspend fun arrayValueSeparator(`value`: Output<String>) {
        this.arrayValueSeparator = value
    }

    /**
     * @param value Describes valid values for an enum property.
     */
    @JvmName("auxqsspeytruwqyq")
    public suspend fun enumValidValues(`value`: Output<List<ProfileEnumValidValuesFormatArgs>>) {
        this.enumValidValues = value
    }

    @JvmName("lgrdhcjeypdapfyv")
    public suspend fun enumValidValues(vararg values: Output<ProfileEnumValidValuesFormatArgs>) {
        this.enumValidValues = Output.all(values.asList())
    }

    /**
     * @param values Describes valid values for an enum property.
     */
    @JvmName("bjwgqpmaaridrduq")
    public suspend fun enumValidValues(values: List<Output<ProfileEnumValidValuesFormatArgs>>) {
        this.enumValidValues = Output.all(values)
    }

    /**
     * @param value Name of the property.
     */
    @JvmName("illgfmrbfteofwho")
    public suspend fun fieldName(`value`: Output<String>) {
        this.fieldName = value
    }

    /**
     * @param value Type of the property.
     */
    @JvmName("vcproqvvgsdhisjw")
    public suspend fun fieldType(`value`: Output<String>) {
        this.fieldType = value
    }

    /**
     * @param value Indicates if the property is actually an array of the fieldType above on the data api.
     */
    @JvmName("ugrhgjnghahphilb")
    public suspend fun isArray(`value`: Output<Boolean>) {
        this.isArray = value
    }

    /**
     * @param value Whether property is available in graph or not.
     */
    @JvmName("qbhrnkddflvscyid")
    public suspend fun isAvailableInGraph(`value`: Output<Boolean>) {
        this.isAvailableInGraph = value
    }

    /**
     * @param value Indicates if the property is an enum.
     */
    @JvmName("yfnjishbsecmibgf")
    public suspend fun isEnum(`value`: Output<Boolean>) {
        this.isEnum = value
    }

    /**
     * @param value Indicates if the property is an flag enum.
     */
    @JvmName("jeedqitqyaqykehe")
    public suspend fun isFlagEnum(`value`: Output<Boolean>) {
        this.isFlagEnum = value
    }

    /**
     * @param value Whether the property is an Image.
     */
    @JvmName("irymuemntsqiqoqm")
    public suspend fun isImage(`value`: Output<Boolean>) {
        this.isImage = value
    }

    /**
     * @param value Whether the property is a localized string.
     */
    @JvmName("uvkaiwryixpxjfnt")
    public suspend fun isLocalizedString(`value`: Output<Boolean>) {
        this.isLocalizedString = value
    }

    /**
     * @param value Whether the property is a name or a part of name.
     */
    @JvmName("vmqfljicdcoryhwa")
    public suspend fun isName(`value`: Output<Boolean>) {
        this.isName = value
    }

    /**
     * @param value Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
     */
    @JvmName("xocjcfggmahekwoq")
    public suspend fun isRequired(`value`: Output<Boolean>) {
        this.isRequired = value
    }

    /**
     * @param value Max length of string. Used only if type is string.
     */
    @JvmName("vumgbsmlpiuqxdcb")
    public suspend fun maxLength(`value`: Output<Int>) {
        this.maxLength = value
    }

    /**
     * @param value The ID associated with the property.
     */
    @JvmName("pcgdkwgapumoreqo")
    public suspend fun propertyId(`value`: Output<String>) {
        this.propertyId = value
    }

    /**
     * @param value URL encoded schema.org item prop link for the property.
     */
    @JvmName("vcfeyvspwwhdlccu")
    public suspend fun schemaItemPropLink(`value`: Output<String>) {
        this.schemaItemPropLink = value
    }

    /**
     * @param value Array value separator for properties with isArray set.
     */
    @JvmName("dvlnupqmgticdljp")
    public suspend fun arrayValueSeparator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arrayValueSeparator = mapped
    }

    /**
     * @param value Describes valid values for an enum property.
     */
    @JvmName("dhhiqnitukeievwy")
    public suspend fun enumValidValues(`value`: List<ProfileEnumValidValuesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enumValidValues = mapped
    }

    /**
     * @param argument Describes valid values for an enum property.
     */
    @JvmName("xupeyvcrajmfjblk")
    public suspend
    fun enumValidValues(argument: List<suspend ProfileEnumValidValuesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProfileEnumValidValuesFormatArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.enumValidValues = mapped
    }

    /**
     * @param argument Describes valid values for an enum property.
     */
    @JvmName("fmkofcuxmalpyrqa")
    public suspend fun enumValidValues(
        vararg
        argument: suspend ProfileEnumValidValuesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ProfileEnumValidValuesFormatArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.enumValidValues = mapped
    }

    /**
     * @param argument Describes valid values for an enum property.
     */
    @JvmName("hnoqireduqrnhjnw")
    public suspend
    fun enumValidValues(argument: suspend ProfileEnumValidValuesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProfileEnumValidValuesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.enumValidValues = mapped
    }

    /**
     * @param values Describes valid values for an enum property.
     */
    @JvmName("dsxmswswisvfeudo")
    public suspend fun enumValidValues(vararg values: ProfileEnumValidValuesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enumValidValues = mapped
    }

    /**
     * @param value Name of the property.
     */
    @JvmName("dcgaskindegfsdjt")
    public suspend fun fieldName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldName = mapped
    }

    /**
     * @param value Type of the property.
     */
    @JvmName("vxkcmcsmgnuhsokj")
    public suspend fun fieldType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldType = mapped
    }

    /**
     * @param value Indicates if the property is actually an array of the fieldType above on the data api.
     */
    @JvmName("kvmnxshmilqdsclv")
    public suspend fun isArray(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArray = mapped
    }

    /**
     * @param value Whether property is available in graph or not.
     */
    @JvmName("gxbyhhnmvgsadusy")
    public suspend fun isAvailableInGraph(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAvailableInGraph = mapped
    }

    /**
     * @param value Indicates if the property is an enum.
     */
    @JvmName("ocgjrvdlljlbnfdq")
    public suspend fun isEnum(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnum = mapped
    }

    /**
     * @param value Indicates if the property is an flag enum.
     */
    @JvmName("eyaengnioyvhkjae")
    public suspend fun isFlagEnum(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isFlagEnum = mapped
    }

    /**
     * @param value Whether the property is an Image.
     */
    @JvmName("xropolhfatpmijme")
    public suspend fun isImage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isImage = mapped
    }

    /**
     * @param value Whether the property is a localized string.
     */
    @JvmName("apkuqwfenpixutwj")
    public suspend fun isLocalizedString(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLocalizedString = mapped
    }

    /**
     * @param value Whether the property is a name or a part of name.
     */
    @JvmName("ujyrjgjpiponthyv")
    public suspend fun isName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isName = mapped
    }

    /**
     * @param value Whether property value is required on instances, IsRequired field only for Interaction. Profile Instance will not check for required field.
     */
    @JvmName("ypsidcfnyntfxmsj")
    public suspend fun isRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRequired = mapped
    }

    /**
     * @param value Max length of string. Used only if type is string.
     */
    @JvmName("itqouwyxrdqfxfim")
    public suspend fun maxLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxLength = mapped
    }

    /**
     * @param value The ID associated with the property.
     */
    @JvmName("oeiedkgxeoiphbfg")
    public suspend fun propertyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyId = mapped
    }

    /**
     * @param value URL encoded schema.org item prop link for the property.
     */
    @JvmName("topwatcvepvmpycb")
    public suspend fun schemaItemPropLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaItemPropLink = mapped
    }

    internal fun build(): PropertyDefinitionArgs = PropertyDefinitionArgs(
        arrayValueSeparator = arrayValueSeparator,
        enumValidValues = enumValidValues,
        fieldName = fieldName ?: throw PulumiNullFieldException("fieldName"),
        fieldType = fieldType ?: throw PulumiNullFieldException("fieldType"),
        isArray = isArray,
        isAvailableInGraph = isAvailableInGraph,
        isEnum = isEnum,
        isFlagEnum = isFlagEnum,
        isImage = isImage,
        isLocalizedString = isLocalizedString,
        isName = isName,
        isRequired = isRequired,
        maxLength = maxLength,
        propertyId = propertyId,
        schemaItemPropLink = schemaItemPropLink,
    )
}
