@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.inputs

import com.pulumi.azurenative.customerinsights.inputs.RelationshipLinkFieldMappingArgs.builder
import com.pulumi.azurenative.customerinsights.kotlin.enums.LinkTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The fields mapping for Relationships.
 * @property interactionFieldName The field name on the Interaction Type.
 * @property linkType Link type.
 * @property relationshipFieldName The field name on the Relationship metadata.
 */
public data class RelationshipLinkFieldMappingArgs(
    public val interactionFieldName: Output<String>,
    public val linkType: Output<LinkTypes>? = null,
    public val relationshipFieldName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.customerinsights.inputs.RelationshipLinkFieldMappingArgs> {
    override fun toJava():
        com.pulumi.azurenative.customerinsights.inputs.RelationshipLinkFieldMappingArgs =
        com.pulumi.azurenative.customerinsights.inputs.RelationshipLinkFieldMappingArgs.builder()
            .interactionFieldName(interactionFieldName.applyValue({ args0 -> args0 }))
            .linkType(linkType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .relationshipFieldName(relationshipFieldName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RelationshipLinkFieldMappingArgs].
 */
@PulumiTagMarker
public class RelationshipLinkFieldMappingArgsBuilder internal constructor() {
    private var interactionFieldName: Output<String>? = null

    private var linkType: Output<LinkTypes>? = null

    private var relationshipFieldName: Output<String>? = null

    /**
     * @param value The field name on the Interaction Type.
     */
    @JvmName("imvvghxsctnriurc")
    public suspend fun interactionFieldName(`value`: Output<String>) {
        this.interactionFieldName = value
    }

    /**
     * @param value Link type.
     */
    @JvmName("hxshshxsoovdpipc")
    public suspend fun linkType(`value`: Output<LinkTypes>) {
        this.linkType = value
    }

    /**
     * @param value The field name on the Relationship metadata.
     */
    @JvmName("mqrpujuaykdknhsu")
    public suspend fun relationshipFieldName(`value`: Output<String>) {
        this.relationshipFieldName = value
    }

    /**
     * @param value The field name on the Interaction Type.
     */
    @JvmName("gbtolxdwpoxqwgpd")
    public suspend fun interactionFieldName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interactionFieldName = mapped
    }

    /**
     * @param value Link type.
     */
    @JvmName("fjmukbsvmbdvsowy")
    public suspend fun linkType(`value`: LinkTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkType = mapped
    }

    /**
     * @param value The field name on the Relationship metadata.
     */
    @JvmName("ypcuxahspcydrnbb")
    public suspend fun relationshipFieldName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.relationshipFieldName = mapped
    }

    internal fun build(): RelationshipLinkFieldMappingArgs = RelationshipLinkFieldMappingArgs(
        interactionFieldName = interactionFieldName ?: throw
            PulumiNullFieldException("interactionFieldName"),
        linkType = linkType,
        relationshipFieldName = relationshipFieldName ?: throw
            PulumiNullFieldException("relationshipFieldName"),
    )
}
