@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customerinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The fields mapping for Relationships.
 * @property interactionFieldName The field name on the Interaction Type.
 * @property linkType Link type.
 * @property relationshipFieldName The field name on the Relationship metadata.
 */
public data class RelationshipLinkFieldMappingResponse(
    public val interactionFieldName: String,
    public val linkType: String? = null,
    public val relationshipFieldName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.customerinsights.outputs.RelationshipLinkFieldMappingResponse):
            RelationshipLinkFieldMappingResponse = RelationshipLinkFieldMappingResponse(
            interactionFieldName = javaType.interactionFieldName(),
            linkType = javaType.linkType().map({ args0 -> args0 }).orElse(null),
            relationshipFieldName = javaType.relationshipFieldName(),
        )
    }
}
