@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.customproviders.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Association].
 */
@PulumiTagMarker
public class AssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssociationArgs = AssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssociationArgsBuilder.() -> Unit) {
        val builder = AssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Association {
        val builtJavaResource =
            com.pulumi.azurenative.customproviders.Association(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Association(builtJavaResource)
    }
}

/**
 * The resource definition of this association.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### Create or update an association
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var association = new AzureNative.CustomProviders.Association("association", new()
 *     {
 *         AssociationName = "associationName",
 *         Scope = "scope",
 *         TargetResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/appRG/providers/Microsoft.Solutions/applications/applicationName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/customproviders/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := customproviders.NewAssociation(ctx, "association", &customproviders.AssociationArgs{
 * 			AssociationName:  pulumi.String("associationName"),
 * 			Scope:            pulumi.String("scope"),
 * 			TargetResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/appRG/providers/Microsoft.Solutions/applications/applicationName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.customproviders.Association;
 * import com.pulumi.azurenative.customproviders.AssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var association = new Association("association", AssociationArgs.builder()
 *             .associationName("associationName")
 *             .scope("scope")
 *             .targetResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/appRG/providers/Microsoft.Solutions/applications/applicationName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:customproviders:Association associationName /{scope}/providers/Microsoft.CustomProviders/associations/{associationName}
 * ```
 */
public class Association internal constructor(
    override val javaResource: com.pulumi.azurenative.customproviders.Association,
) : KotlinCustomResource(javaResource, AssociationMapper) {
    /**
     * The association name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the association.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The REST resource instance of the target resource for this association.
     */
    public val targetResourceId: Output<String>?
        get() = javaResource.targetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The association type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssociationMapper : ResourceMapper<Association> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.customproviders.Association::class == javaResource::class

    override fun map(javaResource: Resource): Association = Association(
        javaResource as
            com.pulumi.azurenative.customproviders.Association,
    )
}

/**
 * @see [Association].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Association].
 */
public suspend fun association(name: String, block: suspend AssociationResourceBuilder.() -> Unit):
    Association {
    val builder = AssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Association].
 * @param name The _unique_ name of the resulting resource.
 */
public fun association(name: String): Association {
    val builder = AssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
