@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin

import com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedGrafanaPropertiesResponse
import com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.dashboard.kotlin.outputs.ResourceSkuResponse
import com.pulumi.azurenative.dashboard.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedGrafanaPropertiesResponse.Companion.toKotlin as managedGrafanaPropertiesResponseToKotlin
import com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.dashboard.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin
import com.pulumi.azurenative.dashboard.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Grafana].
 */
@PulumiTagMarker
public class GrafanaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GrafanaArgs = GrafanaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GrafanaArgsBuilder.() -> Unit) {
        val builder = GrafanaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Grafana {
        val builtJavaResource = com.pulumi.azurenative.dashboard.Grafana(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Grafana(builtJavaResource)
    }
}

/**
 * The grafana resource type.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2022-05-01-preview.
 * Other available API versions: 2021-09-01-preview, 2022-10-01-preview, 2023-09-01.
 * ## Example Usage
 * ### Grafana_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var grafana = new AzureNative.Dashboard.Grafana("grafana", new()
 *     {
 *         Identity = new AzureNative.Dashboard.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = AzureNative.Dashboard.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Location = "West US",
 *         Properties = new AzureNative.Dashboard.Inputs.ManagedGrafanaPropertiesArgs
 *         {
 *             ApiKey = AzureNative.Dashboard.ApiKey.Enabled,
 *             DeterministicOutboundIP = AzureNative.Dashboard.DeterministicOutboundIP.Enabled,
 *             GrafanaIntegrations = new AzureNative.Dashboard.Inputs.GrafanaIntegrationsArgs
 *             {
 *                 AzureMonitorWorkspaceIntegrations = new[]
 *                 {
 *                     new AzureNative.Dashboard.Inputs.AzureMonitorWorkspaceIntegrationArgs
 *                     {
 *                         AzureMonitorWorkspaceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace",
 *                     },
 *                 },
 *             },
 *             PublicNetworkAccess = AzureNative.Dashboard.PublicNetworkAccess.Enabled,
 *             ZoneRedundancy = AzureNative.Dashboard.ZoneRedundancy.Enabled,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Dashboard.Inputs.ResourceSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Dev" },
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dashboard/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dashboard.NewGrafana(ctx, "grafana", &dashboard.GrafanaArgs{
 * 			Identity: &dashboard.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String(dashboard.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			Properties: &dashboard.ManagedGrafanaPropertiesArgs{
 * 				ApiKey:                  pulumi.String(dashboard.ApiKeyEnabled),
 * 				DeterministicOutboundIP: pulumi.String(dashboard.DeterministicOutboundIPEnabled),
 * 				GrafanaIntegrations: &dashboard.GrafanaIntegrationsArgs{
 * 					AzureMonitorWorkspaceIntegrations: dashboard.AzureMonitorWorkspaceIntegrationArray{
 * 						&dashboard.AzureMonitorWorkspaceIntegrationArgs{
 * 							AzureMonitorWorkspaceResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace"),
 * 						},
 * 					},
 * 				},
 * 				PublicNetworkAccess: pulumi.String(dashboard.PublicNetworkAccessEnabled),
 * 				ZoneRedundancy:      pulumi.String(dashboard.ZoneRedundancyEnabled),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &dashboard.ResourceSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Dev"),
 * 			},
 * 			WorkspaceName: pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dashboard.Grafana;
 * import com.pulumi.azurenative.dashboard.GrafanaArgs;
 * import com.pulumi.azurenative.dashboard.inputs.ManagedServiceIdentityArgs;
 * import com.pulumi.azurenative.dashboard.inputs.ManagedGrafanaPropertiesArgs;
 * import com.pulumi.azurenative.dashboard.inputs.GrafanaIntegrationsArgs;
 * import com.pulumi.azurenative.dashboard.inputs.ResourceSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var grafana = new Grafana("grafana", GrafanaArgs.builder()
 *             .identity(ManagedServiceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("West US")
 *             .properties(ManagedGrafanaPropertiesArgs.builder()
 *                 .apiKey("Enabled")
 *                 .deterministicOutboundIP("Enabled")
 *                 .grafanaIntegrations(GrafanaIntegrationsArgs.builder()
 *                     .azureMonitorWorkspaceIntegrations(AzureMonitorWorkspaceIntegrationArgs.builder()
 *                         .azureMonitorWorkspaceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.monitor/accounts/myAzureMonitorWorkspace")
 *                         .build())
 *                     .build())
 *                 .publicNetworkAccess("Enabled")
 *                 .zoneRedundancy("Enabled")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .sku(ResourceSkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.of("Environment", "Dev"))
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dashboard:Grafana myWorkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}
 * ```
 */
public class Grafana internal constructor(
    override val javaResource: com.pulumi.azurenative.dashboard.Grafana,
) : KotlinCustomResource(javaResource, GrafanaMapper) {
    /**
     * The managed identity of the grafana resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the grafana resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the grafana resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties specific to the grafana resource.
     */
    public val properties: Output<ManagedGrafanaPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                managedGrafanaPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The Sku of the grafana resource.
     */
    public val sku: Output<ResourceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system meta data relating to this grafana resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags for grafana resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the grafana resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GrafanaMapper : ResourceMapper<Grafana> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dashboard.Grafana::class == javaResource::class

    override fun map(javaResource: Resource): Grafana = Grafana(
        javaResource as
            com.pulumi.azurenative.dashboard.Grafana,
    )
}

/**
 * @see [Grafana].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Grafana].
 */
public suspend fun grafana(name: String, block: suspend GrafanaResourceBuilder.() -> Unit):
    Grafana {
    val builder = GrafanaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Grafana].
 * @param name The _unique_ name of the resulting resource.
 */
public fun grafana(name: String): Grafana {
    val builder = GrafanaResourceBuilder()
    builder.name(name)
    return builder.build()
}
