@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dashboard.kotlin

import com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedPrivateEndpointConnectionStateResponse
import com.pulumi.azurenative.dashboard.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.dashboard.kotlin.outputs.ManagedPrivateEndpointConnectionStateResponse.Companion.toKotlin as managedPrivateEndpointConnectionStateResponseToKotlin
import com.pulumi.azurenative.dashboard.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedPrivateEndpoint].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPrivateEndpointArgsBuilder.() -> Unit) {
        val builder = ManagedPrivateEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedPrivateEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.dashboard.ManagedPrivateEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedPrivateEndpoint(builtJavaResource)
    }
}

/**
 * The managed private endpoint resource type.
 * Azure REST API version: 2022-10-01-preview.
 * Other available API versions: 2023-09-01.
 * ## Example Usage
 * ### ManagedPrivateEndpoint_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedPrivateEndpoint = new AzureNative.Dashboard.ManagedPrivateEndpoint("managedPrivateEndpoint", new()
 *     {
 *         GroupIds = new[]
 *         {
 *             "grafana",
 *         },
 *         Location = "West US",
 *         ManagedPrivateEndpointName = "myMPEName",
 *         PrivateLinkResourceId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource",
 *         PrivateLinkResourceRegion = "West US",
 *         PrivateLinkServiceUrl = "my-self-hosted-influxdb.westus.mydomain.com",
 *         RequestMessage = "Example Request Message",
 *         ResourceGroupName = "myResourceGroup",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dashboard/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dashboard.NewManagedPrivateEndpoint(ctx, "managedPrivateEndpoint", &dashboard.ManagedPrivateEndpointArgs{
 * 			GroupIds: pulumi.StringArray{
 * 				pulumi.String("grafana"),
 * 			},
 * 			Location:                   pulumi.String("West US"),
 * 			ManagedPrivateEndpointName: pulumi.String("myMPEName"),
 * 			PrivateLinkResourceId:      pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource"),
 * 			PrivateLinkResourceRegion:  pulumi.String("West US"),
 * 			PrivateLinkServiceUrl:      pulumi.String("my-self-hosted-influxdb.westus.mydomain.com"),
 * 			RequestMessage:             pulumi.String("Example Request Message"),
 * 			ResourceGroupName:          pulumi.String("myResourceGroup"),
 * 			WorkspaceName:              pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dashboard.ManagedPrivateEndpoint;
 * import com.pulumi.azurenative.dashboard.ManagedPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedPrivateEndpoint = new ManagedPrivateEndpoint("managedPrivateEndpoint", ManagedPrivateEndpointArgs.builder()
 *             .groupIds("grafana")
 *             .location("West US")
 *             .managedPrivateEndpointName("myMPEName")
 *             .privateLinkResourceId("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource")
 *             .privateLinkResourceRegion("West US")
 *             .privateLinkServiceUrl("my-self-hosted-influxdb.westus.mydomain.com")
 *             .requestMessage("Example Request Message")
 *             .resourceGroupName("myResourceGroup")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dashboard:ManagedPrivateEndpoint myMPEName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/managedPrivateEndpoints/{managedPrivateEndpointName}
 * ```
 */
public class ManagedPrivateEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.dashboard.ManagedPrivateEndpoint,
) : KotlinCustomResource(javaResource, ManagedPrivateEndpointMapper) {
    /**
     * The state of managed private endpoint connection.
     */
    public val connectionState: Output<ManagedPrivateEndpointConnectionStateResponse>
        get() = javaResource.connectionState().applyValue({ args0 ->
            args0.let({ args0 ->
                managedPrivateEndpointConnectionStateResponseToKotlin(args0)
            })
        })

    /**
     * The group Ids of the managed private endpoint.
     */
    public val groupIds: Output<List<String>>?
        get() = javaResource.groupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARM resource ID of the resource for which the managed private endpoint is pointing to.
     */
    public val privateLinkResourceId: Output<String>?
        get() = javaResource.privateLinkResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of the resource to which the managed private endpoint is pointing to.
     */
    public val privateLinkResourceRegion: Output<String>?
        get() = javaResource.privateLinkResourceRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The private IP of private endpoint after approval. This property is empty before connection is approved.
     */
    public val privateLinkServicePrivateIP: Output<String>
        get() = javaResource.privateLinkServicePrivateIP().applyValue({ args0 -> args0 })

    /**
     * The URL of the data store behind the private link service. It would be the URL in the Grafana data source configuration page without the protocol and port.
     */
    public val privateLinkServiceUrl: Output<String>?
        get() = javaResource.privateLinkServiceUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * User input request message of the managed private endpoint.
     */
    public val requestMessage: Output<String>?
        get() = javaResource.requestMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedPrivateEndpointMapper : ResourceMapper<ManagedPrivateEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dashboard.ManagedPrivateEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPrivateEndpoint =
        ManagedPrivateEndpoint(
            javaResource as
                com.pulumi.azurenative.dashboard.ManagedPrivateEndpoint,
        )
}

/**
 * @see [ManagedPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPrivateEndpoint].
 */
public suspend fun managedPrivateEndpoint(
    name: String,
    block: suspend ManagedPrivateEndpointResourceBuilder.() -> Unit,
): ManagedPrivateEndpoint {
    val builder = ManagedPrivateEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPrivateEndpoint(name: String): ManagedPrivateEndpoint {
    val builder = ManagedPrivateEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
