@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databasewatcher.kotlin

import com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.VaultSecretResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.databasewatcher.kotlin.outputs.VaultSecretResponse.Companion.toKotlin as vaultSecretResponseToKotlin

/**
 * Builder for [Target].
 */
@PulumiTagMarker
public class TargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TargetArgs = TargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TargetArgsBuilder.() -> Unit) {
        val builder = TargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Target {
        val builtJavaResource = com.pulumi.azurenative.databasewatcher.Target(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Target(builtJavaResource)
    }
}

/**
 * Concrete proxy resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-09-01-preview.
 * ## Example Usage
 * ### Targets_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var target = new AzureNative.DatabaseWatcher.Target("target", new()
 *     {
 *         ConnectionServerName = "sqlServero1ihe2",
 *         ResourceGroupName = "apiTest-ddat4p",
 *         TargetAuthenticationType = AzureNative.DatabaseWatcher.TargetAuthenticationType.Aad,
 *         TargetName = "monitoringh22eed",
 *         TargetType = "SqlDb",
 *         WatcherName = "databasemo3ej9ih",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databasewatcher/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databasewatcher.NewTarget(ctx, "target", &databasewatcher.TargetArgs{
 * 			ConnectionServerName:     pulumi.String("sqlServero1ihe2"),
 * 			ResourceGroupName:        pulumi.String("apiTest-ddat4p"),
 * 			TargetAuthenticationType: pulumi.String(databasewatcher.TargetAuthenticationTypeAad),
 * 			TargetName:               pulumi.String("monitoringh22eed"),
 * 			TargetType:               pulumi.String("SqlDb"),
 * 			WatcherName:              pulumi.String("databasemo3ej9ih"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databasewatcher.Target;
 * import com.pulumi.azurenative.databasewatcher.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var target = new Target("target", TargetArgs.builder()
 *             .connectionServerName("sqlServero1ihe2")
 *             .resourceGroupName("apiTest-ddat4p")
 *             .targetAuthenticationType("Aad")
 *             .targetName("monitoringh22eed")
 *             .targetType("SqlDb")
 *             .watcherName("databasemo3ej9ih")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databasewatcher:Target monitoringh22eed /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DatabaseWatcher/watchers/{watcherName}/targets/{targetName}
 * ```
 */
public class Target internal constructor(
    override val javaResource: com.pulumi.azurenative.databasewatcher.Target,
) : KotlinCustomResource(javaResource, TargetMapper) {
    /**
     * The server name to use in the connection string when connecting to a target. Port number and instance name must be specified separately.
     */
    public val connectionServerName: Output<String>
        get() = javaResource.connectionServerName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of authentication to use when connecting to a target.
     */
    public val targetAuthenticationType: Output<String>
        get() = javaResource.targetAuthenticationType().applyValue({ args0 -> args0 })

    /**
     * Discriminator property for TargetProperties.
     */
    public val targetType: Output<String>
        get() = javaResource.targetType().applyValue({ args0 -> args0 })

    /**
     * To use SQL authentication when connecting to targets, specify the vault where the login name and password secrets are stored.
     */
    public val targetVault: Output<VaultSecretResponse>?
        get() = javaResource.targetVault().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vaultSecretResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TargetMapper : ResourceMapper<Target> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databasewatcher.Target::class == javaResource::class

    override fun map(javaResource: Resource): Target = Target(
        javaResource as
            com.pulumi.azurenative.databasewatcher.Target,
    )
}

/**
 * @see [Target].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Target].
 */
public suspend fun target(name: String, block: suspend TargetResourceBuilder.() -> Unit): Target {
    val builder = TargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Target].
 * @param name The _unique_ name of the resulting resource.
 */
public fun target(name: String): Target {
    val builder = TargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
